/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.routeservice.Route;

public class ResolvedRoute {
    private final Route route;
    private final MacAddress nextHopMac;
    private final VlanId nextHopVlan;
    private final ConnectPoint location;

    public ResolvedRoute(Route route, MacAddress nextHopMac, ConnectPoint location) {
        this(route, nextHopMac, VlanId.NONE, location);
    }

    public ResolvedRoute(Route route, MacAddress nextHopMac, VlanId nextHopVlan, ConnectPoint location) {
        this.route = route;
        this.nextHopMac = nextHopMac;
        this.nextHopVlan = nextHopVlan;
        this.location = location;
    }

    public Route route() {
        return this.route;
    }

    public IpPrefix prefix() {
        return this.route.prefix();
    }

    public IpAddress nextHop() {
        return this.route.nextHop();
    }

    public MacAddress nextHopMac() {
        return this.nextHopMac;
    }

    public VlanId nextHopVlan() {
        return this.nextHopVlan;
    }

    public ConnectPoint location() {
        return this.location;
    }

    public int hashCode() {
        return Objects.hash(this.route, this.nextHopMac, this.nextHopVlan, this.location);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedRoute)) {
            return false;
        }
        ResolvedRoute that = (ResolvedRoute)other;
        return Objects.equals(this.route, that.route) && Objects.equals(this.nextHopMac, that.nextHopMac) && Objects.equals(this.nextHopVlan, that.nextHopVlan) && Objects.equals(this.location, that.location);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("route", (Object)this.route).add("nextHopMac", (Object)this.nextHopMac).add("nextHopVlan", (Object)this.nextHopVlan).add("location", (Object)this.location).toString();
    }
}

