/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onosproject.routeservice.Route;
import org.onosproject.routeservice.RouteTableId;

public class RouteSet {
    private final RouteTableId tableId;
    private final IpPrefix prefix;
    private final Set<Route> routes;

    public RouteSet(RouteTableId tableId, IpPrefix prefix, Set<Route> routes) {
        this.tableId = (RouteTableId)Preconditions.checkNotNull((Object)tableId);
        this.prefix = (IpPrefix)Preconditions.checkNotNull((Object)prefix);
        this.routes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(routes)));
    }

    public RouteTableId tableId() {
        return this.tableId;
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public Set<Route> routes() {
        return this.routes;
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.prefix, this.routes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RouteSet)) {
            return false;
        }
        RouteSet that = (RouteSet)other;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.routes, that.routes);
    }
}

