/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;

public class NextHopData {
    private final MacAddress mac;
    private final ConnectPoint location;

    public NextHopData(MacAddress mac, ConnectPoint location) {
        this.mac = mac;
        this.location = location;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public ConnectPoint location() {
        return this.location;
    }

    public static NextHopData fromHost(Host host) {
        return new NextHopData(host.mac(), (ConnectPoint)host.location());
    }

    public int hashCode() {
        return Objects.hash(this.mac, this.location);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NextHopData)) {
            return false;
        }
        NextHopData that = (NextHopData)other;
        return Objects.equals(this.mac, that.mac) && Objects.equals(this.location, that.location);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mac", (Object)this.mac).add("location", (Object)this.location).toString();
    }
}

