/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.cluster.NodeId;

public class Route {
    private static final String VERSION_MISMATCH = "Prefix and next hop must be in the same address family";
    private static final NodeId UNDEFINED = new NodeId("-");
    private final Source source;
    private final IpPrefix prefix;
    private final IpAddress nextHop;
    private final NodeId sourceNode;

    public Route(Source source, IpPrefix prefix, IpAddress nextHop) {
        this(source, prefix, nextHop, UNDEFINED);
    }

    public Route(Source source, IpPrefix prefix, IpAddress nextHop, NodeId sourceNode) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)nextHop);
        Preconditions.checkArgument((boolean)prefix.version().equals((Object)nextHop.version()), (Object)VERSION_MISMATCH);
        this.source = (Source)((Object)Preconditions.checkNotNull((Object)((Object)source)));
        this.prefix = prefix;
        this.nextHop = nextHop;
        this.sourceNode = (NodeId)Preconditions.checkNotNull((Object)sourceNode);
    }

    public Source source() {
        return this.source;
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public IpAddress nextHop() {
        return this.nextHop;
    }

    public NodeId sourceNode() {
        return this.sourceNode;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.nextHop);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Route)) {
            return false;
        }
        Route that = (Route)other;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.nextHop, that.nextHop);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).add("nextHop", (Object)this.nextHop).toString();
    }

    public static enum Source {
        BGP,
        FPM,
        STATIC,
        UNDEFINED;

    }
}

