/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.TestApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.routeservice.Route;
import org.onosproject.routeservice.RouteConfig;

public class RouteConfigTest {
    private static final String KEY = "org.onosproject.routing";
    private static final IpPrefix PREFIX1 = IpPrefix.valueOf((String)"10.0.0.1/24");
    private static final IpPrefix PREFIX2 = IpPrefix.valueOf((String)"20.0.0.1/24");
    private static final IpPrefix PREFIX3 = IpPrefix.valueOf((String)"30.0.0.1/24");
    private static final IpAddress NEXTHOP1 = IpAddress.valueOf((String)"192.168.1.1");
    private static final IpAddress NEXTHOP2 = IpAddress.valueOf((String)"192.168.2.1");
    private static final Route ROUTE1 = new Route(Route.Source.STATIC, PREFIX1, NEXTHOP1);
    private static final Route ROUTE2 = new Route(Route.Source.STATIC, PREFIX2, NEXTHOP1);
    private static final Route ROUTE3 = new Route(Route.Source.STATIC, PREFIX3, NEXTHOP2);
    private static final Set<Route> EXPECTED_ROUTES = ImmutableSet.of((Object)ROUTE1, (Object)ROUTE2, (Object)ROUTE3);
    private static final Set<Route> UNEXPECTED_ROUTES = ImmutableSet.of((Object)ROUTE1, (Object)ROUTE2);
    private RouteConfig config;

    @Before
    public void setUp() throws Exception {
        InputStream jsonStream = RouteConfigTest.class.getResourceAsStream("/route-config.json");
        TestApplicationId subject = new TestApplicationId(KEY);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonStream);
        MockDelegate delegate = new MockDelegate();
        this.config = new RouteConfig();
        this.config.init((Object)subject, KEY, jsonNode, mapper, (ConfigApplyDelegate)delegate);
    }

    @Test
    public void getRoutes() throws Exception {
        Assert.assertThat((Object)this.config.getRoutes(), (Matcher)Matchers.is(EXPECTED_ROUTES));
        Assert.assertThat((Object)this.config.getRoutes(), (Matcher)Matchers.not(UNEXPECTED_ROUTES));
    }

    private class MockDelegate
    implements ConfigApplyDelegate {
        private MockDelegate() {
        }

        public void onApply(Config config) {
        }
    }
}

