/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onosproject.routeservice.ResolvedRoute;
import org.onosproject.routeservice.RouteSet;

@Beta
public class RouteInfo {
    private final IpPrefix prefix;
    private final ResolvedRoute bestRoute;
    private final Set<ResolvedRoute> allRoutes;

    @Beta
    public RouteInfo(IpPrefix prefix, ResolvedRoute bestRoute, Set<ResolvedRoute> allRoutes) {
        this.prefix = (IpPrefix)Preconditions.checkNotNull((Object)prefix);
        this.bestRoute = bestRoute;
        this.allRoutes = (Set)Preconditions.checkNotNull(allRoutes);
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public Optional<ResolvedRoute> bestRoute() {
        return Optional.ofNullable(this.bestRoute);
    }

    public Set<ResolvedRoute> allRoutes() {
        return this.allRoutes;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.bestRoute, this.allRoutes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RouteInfo)) {
            return false;
        }
        RouteInfo that = (RouteInfo)other;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.bestRoute, that.bestRoute) && Objects.equals(this.allRoutes, that.allRoutes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(RouteSet.class).add("prefix", (Object)this.prefix).add("bestRoute", (Object)this.bestRoute).add("allRoutes", this.allRoutes).toString();
    }
}

