/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.routeservice.Route;

public class ResolvedRoute {
    private final Route route;
    private final MacAddress nextHopMac;
    private final VlanId nextHopVlan;

    public ResolvedRoute(Route route, MacAddress nextHopMac) {
        this(route, nextHopMac, VlanId.NONE);
    }

    public ResolvedRoute(Route route, MacAddress nextHopMac, VlanId nextHopVlan) {
        this.route = route;
        this.nextHopMac = nextHopMac;
        this.nextHopVlan = nextHopVlan;
    }

    public Route route() {
        return this.route;
    }

    public IpPrefix prefix() {
        return this.route.prefix();
    }

    public IpAddress nextHop() {
        return this.route.nextHop();
    }

    public MacAddress nextHopMac() {
        return this.nextHopMac;
    }

    public VlanId nextHopVlan() {
        return this.nextHopVlan;
    }

    public int hashCode() {
        return Objects.hash(this.route, this.nextHopMac, this.nextHopVlan);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedRoute)) {
            return false;
        }
        ResolvedRoute that = (ResolvedRoute)other;
        return Objects.equals(this.route, that.route) && Objects.equals(this.nextHopMac, that.nextHopMac) && Objects.equals(this.nextHopVlan, that.nextHopVlan);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("route", (Object)this.route).add("nextHopMac", (Object)this.nextHopMac).add("nextHopVlan", (Object)this.nextHopVlan).toString();
    }
}

