/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routeservice;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.onlab.util.Tools;
import org.onosproject.event.AbstractEvent;
import org.onosproject.routeservice.ResolvedRoute;

public class RouteEvent
extends AbstractEvent<Type, ResolvedRoute> {
    private final ResolvedRoute prevSubject;
    private final Collection<ResolvedRoute> alternativeRoutes;
    private final Collection<ResolvedRoute> prevAlternativeRoutes;

    public RouteEvent(Type type, ResolvedRoute subject) {
        this(type, subject, null, Collections.emptySet());
    }

    public RouteEvent(Type type, ResolvedRoute subject, Collection<ResolvedRoute> alternatives) {
        this(type, subject, null, alternatives);
    }

    protected RouteEvent(Type type, ResolvedRoute subject, long time) {
        super((Enum)type, (Object)subject, time);
        this.prevSubject = null;
        this.alternativeRoutes = Collections.emptySet();
        this.prevAlternativeRoutes = null;
    }

    public RouteEvent(Type type, ResolvedRoute subject, ResolvedRoute prevSubject) {
        this(type, subject, prevSubject, Collections.emptySet());
    }

    public RouteEvent(Type type, ResolvedRoute subject, ResolvedRoute prevSubject, Collection<ResolvedRoute> alternatives) {
        this(type, subject, prevSubject, alternatives, null);
    }

    public RouteEvent(Type type, ResolvedRoute subject, ResolvedRoute prevSubject, Collection<ResolvedRoute> alternatives, Collection<ResolvedRoute> prevAlternatives) {
        super((Enum)type, (Object)subject);
        this.prevSubject = prevSubject;
        this.alternativeRoutes = alternatives;
        this.prevAlternativeRoutes = prevAlternatives;
    }

    public ResolvedRoute prevSubject() {
        return this.prevSubject;
    }

    public Collection<ResolvedRoute> alternatives() {
        return this.alternativeRoutes;
    }

    public Collection<ResolvedRoute> prevAlternatives() {
        return this.prevAlternativeRoutes;
    }

    public int hashCode() {
        return Objects.hash(this.subject(), this.type(), this.prevSubject(), this.alternativeRoutes, this.prevAlternativeRoutes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RouteEvent)) {
            return false;
        }
        RouteEvent that = (RouteEvent)((Object)other);
        return Objects.equals(this.subject(), that.subject()) && Objects.equals(this.type(), that.type()) && Objects.equals(this.prevSubject, that.prevSubject) && Objects.equals(this.alternativeRoutes, that.alternativeRoutes) && Objects.equals(this.prevAlternativeRoutes, that.prevAlternativeRoutes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("time", (Object)Tools.defaultOffsetDataTime((long)this.time())).add("type", (Object)this.type()).add("subject", this.subject()).add("prevSubject", (Object)this.prevSubject).add("alternatives", this.alternativeRoutes).add("prevAlternatives", this.prevAlternativeRoutes).toString();
    }

    public static enum Type {
        ROUTE_ADDED,
        ROUTE_UPDATED,
        ROUTE_REMOVED,
        ALTERNATIVE_ROUTES_CHANGED;

    }
}

