/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.intf.InterfaceServiceAdapter;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.NetworkConfigServiceAdapter;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.impl.ControlPlaneRedirectManager;

public class ControlPlaneRedirectManagerTest {
    private DeviceService deviceService;
    private FlowObjectiveService flowObjectiveService;
    private NetworkConfigService networkConfigService;
    private final Set<Interface> interfaces = Sets.newHashSet();
    static Device dev3 = NetTestTools.device((String)"0000000000000001");
    private static final int OSPF_IP_PROTO = 89;
    private CoreService coreService = new TestCoreService();
    private InterfaceService interfaceService;
    private static final ApplicationId APPID = TestApplicationId.create("org.onosproject.vrouter");
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"of:0000000000000001");
    private ConnectPoint controlPlaneConnectPoint = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW1_ETH1 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW1_ETH2 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)2L));
    private static final ConnectPoint SW1_ETH3 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)3L));
    private ControlPlaneRedirectManager controlPlaneRedirectManager = new ControlPlaneRedirectManager();
    private RouterConfig routerConfig = new TestRouterConfig();
    private NetworkConfigListener networkConfigListener;
    private DeviceListener deviceListener;
    private MastershipService mastershipService = new InternalMastershipServiceTest();
    private InterfaceListener interfaceListener;
    private ApplicationService applicationService;

    @Before
    public void setUp() {
        this.networkConfigListener = (NetworkConfigListener)EasyMock.createMock(NetworkConfigListener.class);
        this.deviceService = new TestDeviceService();
        this.deviceListener = (DeviceListener)EasyMock.createMock(DeviceListener.class);
        this.interfaceListener = (InterfaceListener)EasyMock.createMock(InterfaceListener.class);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.setUpInterfaceService();
        this.interfaceService = new InternalInterfaceService();
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.networkConfigService = new TestNetworkConfigService();
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.flowObjectiveService = (FlowObjectiveService)EasyMock.createMock(FlowObjectiveService.class);
        this.applicationService = (ApplicationService)EasyMock.createNiceMock(ApplicationService.class);
        EasyMock.replay((Object[])new Object[]{this.applicationService});
        this.setUpFlowObjectiveService();
        this.controlPlaneRedirectManager.coreService = this.coreService;
        this.controlPlaneRedirectManager.flowObjectiveService = this.flowObjectiveService;
        this.controlPlaneRedirectManager.networkConfigService = this.networkConfigService;
        this.controlPlaneRedirectManager.interfaceService = this.interfaceService;
        this.controlPlaneRedirectManager.deviceService = this.deviceService;
        this.controlPlaneRedirectManager.hostService = (HostService)EasyMock.createNiceMock(HostService.class);
        this.controlPlaneRedirectManager.mastershipService = this.mastershipService;
        this.controlPlaneRedirectManager.applicationService = this.applicationService;
        this.controlPlaneRedirectManager.activate();
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testAddDevice() {
        ConnectPoint sw1eth4 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)4L));
        ArrayList<InterfaceIpAddress> interfaceIpAddresses4 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses4.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.40.101"), IpPrefix.valueOf((String)"192.168.40.0/24")));
        Interface sw1Eth4 = new Interface(sw1eth4.deviceId().toString(), sw1eth4, interfaceIpAddresses4, MacAddress.valueOf((String)"00:00:00:00:00:04"), VlanId.NONE);
        this.interfaces.add(sw1Eth4);
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        this.setUpFlowObjectiveService();
        this.deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, dev3));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testUpdateNetworkConfig() {
        ConnectPoint sw1eth4 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)4L));
        ArrayList<InterfaceIpAddress> interfaceIpAddresses4 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses4.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.40.101"), IpPrefix.valueOf((String)"192.168.40.0/24")));
        Interface sw1Eth4 = new Interface(sw1eth4.deviceId().toString(), sw1eth4, interfaceIpAddresses4, MacAddress.valueOf((String)"00:00:00:00:00:04"), VlanId.NONE);
        this.interfaces.add(sw1Eth4);
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        this.setUpFlowObjectiveService();
        this.networkConfigListener.event((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_UPDATED, (Object)dev3, RoutingService.ROUTER_CONFIG_CLASS));
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testAddInterface() {
        ConnectPoint sw1eth4 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)4L));
        ArrayList<InterfaceIpAddress> interfaceIpAddresses4 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses4.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.40.101"), IpPrefix.valueOf((String)"192.168.40.0/24")));
        Interface sw1Eth4 = new Interface(sw1eth4.deviceId().toString(), sw1eth4, interfaceIpAddresses4, MacAddress.valueOf((String)"00:00:00:00:00:04"), VlanId.NONE);
        this.interfaces.add(sw1Eth4);
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        EasyMock.expect((Object)this.flowObjectiveService.allocateNextId()).andReturn((Object)1).anyTimes();
        this.setUpInterfaceConfiguration(sw1Eth4, true);
        EasyMock.replay((Object[])new Object[]{this.flowObjectiveService});
        this.interfaceListener.event((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_ADDED, sw1Eth4, 500L));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testRemoveInterface() {
        ConnectPoint sw1eth4 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)4L));
        ArrayList<InterfaceIpAddress> interfaceIpAddresses4 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses4.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.40.101"), IpPrefix.valueOf((String)"192.168.40.0/24")));
        Interface sw1Eth4 = new Interface(sw1eth4.deviceId().toString(), sw1eth4, interfaceIpAddresses4, MacAddress.valueOf((String)"00:00:00:00:00:04"), VlanId.NONE);
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        EasyMock.expect((Object)this.flowObjectiveService.allocateNextId()).andReturn((Object)1).anyTimes();
        this.setUpInterfaceConfiguration(sw1Eth4, false);
        EasyMock.replay((Object[])new Object[]{this.flowObjectiveService});
        this.interfaceListener.event((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_REMOVED, sw1Eth4, 500L));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    private void setUpFlowObjectiveService() {
        EasyMock.expect((Object)this.flowObjectiveService.allocateNextId()).andReturn((Object)1).anyTimes();
        for (Interface intf : this.interfaceService.getInterfaces()) {
            this.setUpInterfaceConfiguration(intf, true);
        }
        EasyMock.replay((Object[])new Object[]{this.flowObjectiveService});
    }

    private void setUpInterfaceConfiguration(Interface intf, boolean install) {
        DeviceId deviceId = this.controlPlaneConnectPoint.deviceId();
        PortNumber controlPlanePort = this.controlPlaneConnectPoint.port();
        for (InterfaceIpAddress ip : intf.ipAddresses()) {
            int cpNextId = this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install);
            int intfNextId = this.modifyNextObjective(deviceId, intf.connectPoint().port(), VlanId.vlanId((short)4094), true, install);
            TrafficSelector toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthDst(intf.mac()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchVlanId(intf.vlan()).matchIPDst(ip.ipAddress().toIpPrefix()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(toSelector, null, cpNextId, install));
            EasyMock.expectLastCall().once();
            TrafficSelector fromSelector = DefaultTrafficSelector.builder().matchInPort(controlPlanePort).matchEthSrc(intf.mac()).matchVlanId(intf.vlan()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchIPSrc(ip.ipAddress().toIpPrefix()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(fromSelector, null, intfNextId, install));
            EasyMock.expectLastCall().once();
            toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthType(EthType.EtherType.ARP.ethType().toShort()).matchVlanId(intf.vlan()).build();
            TrafficTreatment puntTreatment = DefaultTrafficTreatment.builder().punt().build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(toSelector, puntTreatment, cpNextId, install));
            EasyMock.expectLastCall().once();
            fromSelector = DefaultTrafficSelector.builder().matchInPort(controlPlanePort).matchEthSrc(intf.mac()).matchVlanId(intf.vlan()).matchEthType(EthType.EtherType.ARP.ethType().toShort()).matchArpSpa(ip.ipAddress().getIp4Address()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(fromSelector, puntTreatment, intfNextId, install));
            EasyMock.expectLastCall().once();
        }
        TrafficSelector toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchVlanId(intf.vlan()).matchIPProtocol((byte)89).build();
        this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install);
        this.flowObjectiveService.forward(this.controlPlaneConnectPoint.deviceId(), this.buildForwardingObjective(toSelector, null, 1, install));
        EasyMock.expectLastCall().once();
    }

    private int modifyNextObjective(DeviceId deviceId, PortNumber portNumber, VlanId vlanId, boolean popVlan, boolean modifyFlag) {
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(1).withType(NextObjective.Type.SIMPLE).fromApp(APPID);
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (popVlan) {
            ttBuilder.popVlan();
        }
        ttBuilder.setOutput(portNumber);
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
        metabuilder.matchVlanId(vlanId);
        nextObjBuilder.withMeta(metabuilder.build());
        nextObjBuilder.addTreatment(ttBuilder.build());
        if (modifyFlag) {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.add());
            EasyMock.expectLastCall().once();
        } else {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.remove());
            EasyMock.expectLastCall().once();
        }
        return 1;
    }

    private void setUpInterfaceService() {
        ArrayList<InterfaceIpAddress> interfaceIpAddresses1 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses1.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.10.101"), IpPrefix.valueOf((String)"192.168.10.0/24")));
        Interface sw1Eth1 = new Interface(SW1_ETH1.deviceId().toString(), SW1_ETH1, interfaceIpAddresses1, MacAddress.valueOf((String)"00:00:00:00:00:01"), VlanId.NONE);
        this.interfaces.add(sw1Eth1);
        ArrayList<InterfaceIpAddress> interfaceIpAddresses2 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses2.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.20.101"), IpPrefix.valueOf((String)"192.168.20.0/24")));
        Interface sw1Eth2 = new Interface(SW1_ETH1.deviceId().toString(), SW1_ETH2, interfaceIpAddresses2, MacAddress.valueOf((String)"00:00:00:00:00:02"), VlanId.NONE);
        this.interfaces.add(sw1Eth2);
        ArrayList<InterfaceIpAddress> interfaceIpAddresses3 = new ArrayList<InterfaceIpAddress>();
        interfaceIpAddresses3.add(new InterfaceIpAddress(IpAddress.valueOf((String)"192.168.30.101"), IpPrefix.valueOf((String)"192.168.30.0/24")));
        Interface sw1Eth3 = new Interface(SW1_ETH1.deviceId().toString(), SW1_ETH3, interfaceIpAddresses3, MacAddress.valueOf((String)"00:00:00:00:00:03"), VlanId.NONE);
        this.interfaces.add(sw1Eth3);
    }

    private ForwardingObjective buildForwardingObjective(TrafficSelector selector, TrafficTreatment treatment, int nextId, boolean add) {
        DefaultForwardingObjective.Builder fobBuilder = DefaultForwardingObjective.builder();
        fobBuilder.withSelector(selector);
        if (treatment != null) {
            fobBuilder.withTreatment(treatment);
        }
        if (nextId != -1) {
            fobBuilder.nextStep(nextId);
        }
        fobBuilder.fromApp(APPID).withPriority(40001).withFlag(ForwardingObjective.Flag.VERSATILE);
        return add ? fobBuilder.add() : fobBuilder.remove();
    }

    private class InternalInterfaceService
    extends InterfaceServiceAdapter {
        private InternalInterfaceService() {
        }

        public void addListener(InterfaceListener listener) {
            ControlPlaneRedirectManagerTest.this.interfaceListener = listener;
        }

        public Set<Interface> getInterfaces() {
            return ControlPlaneRedirectManagerTest.this.interfaces;
        }

        public Set<Interface> getInterfacesByPort(ConnectPoint port) {
            HashSet<Interface> setIntf = new HashSet<Interface>();
            for (Interface intf : ControlPlaneRedirectManagerTest.this.interfaces) {
                if (!intf.connectPoint().equals((Object)port)) continue;
                setIntf.add(intf);
            }
            return setIntf;
        }

        public Interface getMatchingInterface(IpAddress ip) {
            Interface intff = null;
            block0: for (Interface intf : ControlPlaneRedirectManagerTest.this.interfaces) {
                for (InterfaceIpAddress address : intf.ipAddresses()) {
                    if (!address.ipAddress().equals((Object)ip)) continue;
                    intff = intf;
                    continue block0;
                }
            }
            return intff;
        }
    }

    private class InternalMastershipServiceTest
    extends MastershipServiceAdapter {
        private InternalMastershipServiceTest() {
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            boolean flag = deviceId.equals((Object)ControlPlaneRedirectManagerTest.this.controlPlaneConnectPoint.deviceId());
            return flag;
        }
    }

    private static class TestApplicationId
    implements ApplicationId {
        private final String name;
        private final short id;

        public TestApplicationId(String name) {
            this.name = name;
            this.id = (short)Objects.hash(name);
        }

        public static ApplicationId create(String name) {
            return new TestApplicationId(name);
        }

        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestApplicationId other = (TestApplicationId)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private class TestNetworkConfigService
    extends NetworkConfigServiceAdapter {
        private TestNetworkConfigService() {
        }

        public void addListener(NetworkConfigListener listener) {
            ControlPlaneRedirectManagerTest.this.networkConfigListener = listener;
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            return (C)ControlPlaneRedirectManagerTest.this.routerConfig;
        }
    }

    private class TestRouterConfig
    extends RouterConfig {
        private TestRouterConfig() {
        }

        public ConnectPoint getControlPlaneConnectPoint() {
            return ControlPlaneRedirectManagerTest.this.controlPlaneConnectPoint;
        }

        public boolean getOspfEnabled() {
            return true;
        }

        public List<String> getInterfaces() {
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add("of:0000000000000001");
            interfaces.add("of:0000000000000001/2");
            interfaces.add("of:0000000000000001/3");
            return interfaces;
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private TestDeviceService() {
        }

        public boolean isAvailable(DeviceId deviceId) {
            boolean flag = false;
            if (deviceId.equals((Object)ControlPlaneRedirectManagerTest.this.controlPlaneConnectPoint.deviceId())) {
                flag = true;
            }
            return flag;
        }

        public void addListener(DeviceListener listener) {
            ControlPlaneRedirectManagerTest.this.deviceListener = listener;
        }
    }

    private class TestCoreService
    extends CoreServiceAdapter {
        private TestCoreService() {
        }

        public ApplicationId getAppId(String name) {
            return APPID;
        }

        public ApplicationId registerApplication(String name) {
            return new TestApplicationId(name);
        }
    }
}

