/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.intf.InterfaceServiceAdapter;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteServiceAdapter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.impl.SingleSwitchFibInstaller;
import org.osgi.service.component.ComponentContext;

public class SingleSwitchFibInstallerTest {
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"of:0000000000000001");
    private static final ConnectPoint SW1_ETH1 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW1_ETH2 = new ConnectPoint((ElementId)DEVICE_ID, PortNumber.portNumber((long)2L));
    private static final int NEXT_ID = 11;
    private static final VlanId VLAN1 = VlanId.vlanId((short)1);
    private static final MacAddress MAC1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress MAC2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private static final IpPrefix PREFIX1 = Ip4Prefix.valueOf((String)"1.1.1.0/24");
    private static final IpAddress NEXT_HOP1 = IpAddress.valueOf((String)"192.168.10.1");
    private static final IpAddress NEXT_HOP2 = IpAddress.valueOf((String)"192.168.20.1");
    private static final InterfaceIpAddress INTF1 = InterfaceIpAddress.valueOf((String)"192.168.10.2/24");
    private static final InterfaceIpAddress INTF2 = InterfaceIpAddress.valueOf((String)"192.168.20.2/24");
    private final Set<Interface> interfaces = Sets.newHashSet();
    private InterfaceService interfaceService;
    private NetworkConfigService networkConfigService;
    private NetworkConfigRegistry networkConfigRegistry;
    private FlowObjectiveService flowObjectiveService;
    private ApplicationService applicationService;
    private DeviceService deviceService;
    private static final ApplicationId APPID = TestApplicationId.create((String)"foo");
    private RouteListener routeListener;
    private DeviceListener deviceListener;
    private RouterConfig routerConfig;
    private SingleSwitchFibInstaller sSfibInstaller;
    private InterfaceListener interfaceListener;

    @Before
    public void setUp() throws Exception {
        this.sSfibInstaller = new SingleSwitchFibInstaller();
        this.sSfibInstaller.componentConfigService = (ComponentConfigService)EasyMock.createNiceMock(ComponentConfigService.class);
        ComponentContext mockContext = (ComponentContext)EasyMock.createNiceMock(ComponentContext.class);
        this.routerConfig = new TestRouterConfig();
        this.interfaceService = (InterfaceService)EasyMock.createMock(InterfaceService.class);
        this.networkConfigService = (NetworkConfigService)EasyMock.createMock(NetworkConfigService.class);
        this.networkConfigService.addListener((EventListener)EasyMock.anyObject(NetworkConfigListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.networkConfigRegistry = (NetworkConfigRegistry)EasyMock.createMock(NetworkConfigRegistry.class);
        this.flowObjectiveService = (FlowObjectiveService)EasyMock.createMock(FlowObjectiveService.class);
        this.applicationService = (ApplicationService)EasyMock.createNiceMock(ApplicationService.class);
        EasyMock.replay((Object[])new Object[]{this.applicationService});
        this.deviceService = new TestDeviceService();
        CoreService coreService = (CoreService)EasyMock.createNiceMock(CoreService.class);
        EasyMock.expect((Object)coreService.registerApplication(EasyMock.anyString())).andReturn((Object)APPID).anyTimes();
        EasyMock.replay((Object[])new Object[]{coreService});
        this.sSfibInstaller.networkConfigService = this.networkConfigService;
        this.sSfibInstaller.networkConfigRegistry = this.networkConfigRegistry;
        this.sSfibInstaller.interfaceService = this.interfaceService;
        this.sSfibInstaller.flowObjectiveService = this.flowObjectiveService;
        this.sSfibInstaller.applicationService = this.applicationService;
        this.sSfibInstaller.coreService = coreService;
        this.sSfibInstaller.routeService = new TestRouteService();
        this.sSfibInstaller.deviceService = this.deviceService;
        this.setUpNetworkConfigService();
        this.setUpInterfaceService();
        this.sSfibInstaller.activate(mockContext);
    }

    private void setUpInterfaceService() {
        this.interfaceService.addListener((EventListener)EasyMock.anyObject(InterfaceListener.class));
        EasyMock.expectLastCall().andDelegateTo((Object)new TestInterfaceService());
        Interface sw1Eth1 = new Interface("intf1", SW1_ETH1, Collections.singletonList(INTF1), MAC1, VlanId.NONE);
        EasyMock.expect((Object)this.interfaceService.getMatchingInterface(NEXT_HOP1)).andReturn((Object)sw1Eth1);
        this.interfaces.add(sw1Eth1);
        Interface sw2Eth1 = new Interface("intf2", SW1_ETH2, Collections.singletonList(INTF2), MAC2, VLAN1);
        EasyMock.expect((Object)this.interfaceService.getMatchingInterface(NEXT_HOP2)).andReturn((Object)sw2Eth1);
        this.interfaces.add(sw2Eth1);
        EasyMock.expect((Object)this.interfaceService.getInterfaces()).andReturn(this.interfaces);
        EasyMock.replay((Object[])new Object[]{this.interfaceService});
    }

    private void setUpNetworkConfigService() {
        EasyMock.expect((Object)this.networkConfigService.getConfig(EasyMock.anyObject(ApplicationId.class), (Class)EasyMock.eq((Object)RoutingService.ROUTER_CONFIG_CLASS))).andReturn((Object)this.routerConfig);
        EasyMock.replay((Object[])new Object[]{this.networkConfigService});
    }

    private void setUpFlowObjectiveService() {
        EasyMock.expect((Object)this.flowObjectiveService.allocateNextId()).andReturn((Object)11);
        EasyMock.replay((Object[])new Object[]{this.flowObjectiveService});
    }

    private NextObjective createNextObjective(MacAddress srcMac, MacAddress dstMac, PortNumber port, VlanId vlan, boolean add) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthSrc(srcMac).setEthDst(dstMac);
        TrafficSelector.Builder metabuilder = null;
        if (!vlan.equals((Object)VlanId.NONE)) {
            treatment.pushVlan().setVlanId(vlan).setVlanPcp(Byte.valueOf((byte)0));
        } else {
            metabuilder = DefaultTrafficSelector.builder();
            metabuilder.matchVlanId(VlanId.vlanId((short)4094));
        }
        treatment.setOutput(port);
        DefaultNextObjective.Builder nextBuilder = DefaultNextObjective.builder().withId(11).addTreatment(treatment.build()).withType(NextObjective.Type.SIMPLE).fromApp(APPID);
        if (metabuilder != null) {
            nextBuilder.withMeta(metabuilder.build());
        }
        return add ? nextBuilder.add() : nextBuilder.remove();
    }

    private ForwardingObjective createForwardingObjective(IpPrefix prefix, boolean add) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(prefix).build();
        int priority = prefix.prefixLength() * 5 + 100;
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(APPID).makePermanent().withSelector(selector).withPriority(priority).withFlag(ForwardingObjective.Flag.SPECIFIC);
        if (add) {
            fwdBuilder.nextStep(11);
        } else {
            fwdBuilder.withTreatment(DefaultTrafficTreatment.builder().build());
        }
        return add ? fwdBuilder.add() : fwdBuilder.remove();
    }

    @Test
    public void testRouteAdd() {
        ResolvedRoute resolvedRoute = new ResolvedRoute(PREFIX1, NEXT_HOP1, MAC1);
        NextObjective nextObjective = this.createNextObjective(MAC1, MAC1, SW1_ETH1.port(), VlanId.NONE, true);
        this.flowObjectiveService.next(DEVICE_ID, nextObjective);
        ForwardingObjective fwd = this.createForwardingObjective(PREFIX1, true);
        this.flowObjectiveService.forward(DEVICE_ID, fwd);
        EasyMock.expectLastCall().once();
        this.setUpFlowObjectiveService();
        RouteEvent routeEvent = new RouteEvent(RouteEvent.Type.ROUTE_ADDED, resolvedRoute);
        this.routeListener.event((Event)routeEvent);
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testRouteAddWithVlan() {
        ResolvedRoute route = new ResolvedRoute(PREFIX1, NEXT_HOP2, MAC2);
        NextObjective nextObjective = this.createNextObjective(MAC2, MAC2, SW1_ETH2.port(), VLAN1, true);
        this.flowObjectiveService.next(DEVICE_ID, nextObjective);
        ForwardingObjective fwd = this.createForwardingObjective(PREFIX1, true);
        this.flowObjectiveService.forward(DEVICE_ID, fwd);
        EasyMock.expectLastCall().once();
        this.setUpFlowObjectiveService();
        this.routeListener.event((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, route));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testRouteUpdate() {
        this.testRouteAdd();
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        ResolvedRoute route = new ResolvedRoute(PREFIX1, NEXT_HOP2, MAC2);
        NextObjective nextObjective = this.createNextObjective(MAC2, MAC2, SW1_ETH2.port(), VLAN1, true);
        this.flowObjectiveService.next(DEVICE_ID, nextObjective);
        ForwardingObjective fwd = this.createForwardingObjective(PREFIX1, true);
        this.flowObjectiveService.forward(DEVICE_ID, fwd);
        EasyMock.expectLastCall().once();
        this.setUpFlowObjectiveService();
        this.routeListener.event((Event)new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, route));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    @Test
    public void testRouteDelete() {
        this.testRouteAdd();
        ResolvedRoute route = new ResolvedRoute(PREFIX1, null, null);
        EasyMock.reset((Object[])new Object[]{this.flowObjectiveService});
        ForwardingObjective fwd = this.createForwardingObjective(PREFIX1, false);
        this.flowObjectiveService.forward(DEVICE_ID, fwd);
        EasyMock.replay((Object[])new Object[]{this.flowObjectiveService});
        this.routeListener.event((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, route));
        EasyMock.verify((Object[])new Object[]{this.flowObjectiveService});
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private TestDeviceService() {
        }

        public boolean isAvailable(DeviceId deviceId) {
            return true;
        }

        public void addListener(DeviceListener listener) {
            SingleSwitchFibInstallerTest.this.deviceListener = listener;
        }
    }

    private class TestRouterConfig
    extends RouterConfig {
        private TestRouterConfig() {
        }

        public List<String> getInterfaces() {
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add("of:0000000000000001/1");
            interfaces.add("of:0000000000000001/2");
            return interfaces;
        }

        public ConnectPoint getControlPlaneConnectPoint() {
            return SW1_ETH1;
        }

        public boolean getOspfEnabled() {
            return true;
        }
    }

    private class TestRouteService
    extends RouteServiceAdapter {
        private TestRouteService() {
        }

        public void addListener(RouteListener listener) {
            SingleSwitchFibInstallerTest.this.routeListener = listener;
        }
    }

    private class TestInterfaceService
    extends InterfaceServiceAdapter {
        private TestInterfaceService() {
        }

        public void addListener(InterfaceListener listener) {
            SingleSwitchFibInstallerTest.this.interfaceListener = listener;
        }
    }
}

