/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BgpMessage {
    private static final Logger log = LoggerFactory.getLogger(BgpMessage.class);

    private BgpMessage() {
    }

    static ChannelBuffer prepareBgpMessage(int type, ChannelBuffer payload) {
        ChannelBuffer message = ChannelBuffers.buffer((int)(19 + payload.readableBytes()));
        for (int i = 0; i < 16; ++i) {
            message.writeByte(255);
        }
        message.writeShort(19 + payload.readableBytes());
        message.writeByte(type);
        message.writeBytes(payload);
        return message;
    }

    static final class BgpParseException
    extends Exception {
        private BgpParseException() {
        }

        BgpParseException(String message) {
            super(message);
        }
    }
}

