/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.routing.bgp.BgpMessage;
import org.onosproject.routing.bgp.BgpNotification;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpRouteSelector;
import org.onosproject.routing.bgp.BgpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BgpUpdate {
    private static final Logger log = LoggerFactory.getLogger(BgpUpdate.class);

    private BgpUpdate() {
    }

    static void processBgpUpdate(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message) {
        DecodedBgpRoutes decodedBgpRoutes = new DecodedBgpRoutes();
        int minLength = 4;
        if (message.readableBytes() < minLength) {
            log.debug("BGP RX UPDATE Error from {}: Message length {} too short. Must be at least {}", new Object[]{bgpSession.remoteInfo().address(), message.readableBytes(), minLength});
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotificationBadMessageLength(message.readableBytes() + 19);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        log.debug("BGP RX UPDATE message from {}", (Object)bgpSession.remoteInfo().address());
        int withdrawnRoutesLength = message.readUnsignedShort();
        if (withdrawnRoutesLength > message.readableBytes()) {
            BgpUpdate.actionsBgpUpdateMalformedAttributeList(bgpSession, ctx);
            return;
        }
        Collection<Ip4Prefix> withdrawnPrefixes = null;
        try {
            withdrawnPrefixes = BgpUpdate.parsePackedIp4Prefixes(withdrawnRoutesLength, message);
        }
        catch (BgpMessage.BgpParseException e) {
            log.debug("Exception parsing Withdrawn Prefixes from BGP peer {}: ", (Object)bgpSession.remoteInfo().bgpId(), (Object)e);
            BgpUpdate.actionsBgpUpdateInvalidNetworkField(bgpSession, ctx);
            return;
        }
        for (Ip4Prefix prefix : withdrawnPrefixes) {
            log.debug("BGP RX UPDATE message WITHDRAWN from {}: {}", (Object)bgpSession.remoteInfo().address(), (Object)prefix);
            BgpRouteEntry bgpRouteEntry = bgpSession.findBgpRoute(prefix);
            if (bgpRouteEntry == null) continue;
            decodedBgpRoutes.deletedUnicastRoutes4.put(prefix, bgpRouteEntry);
        }
        try {
            BgpUpdate.parsePathAttributes(bgpSession, ctx, message, decodedBgpRoutes);
        }
        catch (BgpMessage.BgpParseException e) {
            log.debug("Exception parsing Path Attributes from BGP peer {}: ", (Object)bgpSession.remoteInfo().bgpId(), (Object)e);
            return;
        }
        for (Ip4Prefix ip4Prefix : decodedBgpRoutes.deletedUnicastRoutes4.keySet()) {
            bgpSession.removeBgpRoute(ip4Prefix);
        }
        for (BgpRouteEntry bgpRouteEntry : decodedBgpRoutes.addedUnicastRoutes4.values()) {
            bgpSession.addBgpRoute(bgpRouteEntry);
        }
        for (Ip6Prefix ip6Prefix : decodedBgpRoutes.deletedUnicastRoutes6.keySet()) {
            bgpSession.removeBgpRoute(ip6Prefix);
        }
        for (BgpRouteEntry bgpRouteEntry : decodedBgpRoutes.addedUnicastRoutes6.values()) {
            bgpSession.addBgpRoute(bgpRouteEntry);
        }
        BgpRouteSelector bgpRouteSelector = bgpSession.getBgpSessionManager().getBgpRouteSelector();
        bgpRouteSelector.routeUpdates(decodedBgpRoutes.addedUnicastRoutes4.values(), decodedBgpRoutes.deletedUnicastRoutes4.values());
        bgpRouteSelector.routeUpdates(decodedBgpRoutes.addedUnicastRoutes6.values(), decodedBgpRoutes.deletedUnicastRoutes6.values());
        bgpSession.restartSessionTimeoutTimer(ctx);
    }

    private static void parsePathAttributes(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message, DecodedBgpRoutes decodedBgpRoutes) throws BgpMessage.BgpParseException {
        Short origin = -1;
        BgpRouteEntry.AsPath asPath = null;
        MpNlri legacyNlri = new MpNlri(1, 1);
        long multiExitDisc = 0L;
        Long localPref = null;
        Long aggregatorAsNumber = null;
        Ip4Address aggregatorIpAddress = null;
        ArrayList<MpNlri> mpNlriReachList = new ArrayList<MpNlri>();
        ArrayList<MpNlri> mpNlriUnreachList = new ArrayList<MpNlri>();
        int pathAttributeLength = message.readUnsignedShort();
        if (pathAttributeLength > message.readableBytes()) {
            BgpUpdate.actionsBgpUpdateMalformedAttributeList(bgpSession, ctx);
            String errorMsg = "Malformed Attribute List";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (pathAttributeLength == 0) {
            return;
        }
        int pathAttributeEnd = message.readerIndex() + pathAttributeLength;
        block13: while (message.readerIndex() < pathAttributeEnd) {
            String errorMsg;
            short attrFlags = message.readUnsignedByte();
            if (message.readerIndex() >= pathAttributeEnd) {
                BgpUpdate.actionsBgpUpdateMalformedAttributeList(bgpSession, ctx);
                String errorMsg2 = "Malformed Attribute List";
                throw new BgpMessage.BgpParseException(errorMsg2);
            }
            short attrTypeCode = message.readUnsignedByte();
            boolean optionalBit = (0x80 & attrFlags) != 0;
            boolean transitiveBit = (0x40 & attrFlags) != 0;
            boolean partialBit = (0x20 & attrFlags) != 0;
            boolean extendedLengthBit = (0x10 & attrFlags) != 0;
            int attrLen = 0;
            int attrLenOctets = 1;
            if (extendedLengthBit) {
                attrLenOctets = 2;
            }
            if (message.readerIndex() + attrLenOctets > pathAttributeEnd) {
                BgpUpdate.actionsBgpUpdateMalformedAttributeList(bgpSession, ctx);
                errorMsg = "Malformed Attribute List";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            attrLen = extendedLengthBit ? message.readUnsignedShort() : (int)message.readUnsignedByte();
            if (message.readerIndex() + attrLen > pathAttributeEnd) {
                BgpUpdate.actionsBgpUpdateMalformedAttributeList(bgpSession, ctx);
                errorMsg = "Malformed Attribute List";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            BgpUpdate.verifyBgpUpdateAttributeFlags(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            switch (attrTypeCode) {
                case 1: {
                    origin = BgpUpdate.parseAttributeTypeOrigin(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 2: {
                    asPath = BgpUpdate.parseAttributeTypeAsPath(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 3: {
                    legacyNlri.nextHop4 = BgpUpdate.parseAttributeTypeNextHop(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 4: {
                    multiExitDisc = BgpUpdate.parseAttributeTypeMultiExitDisc(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 5: {
                    localPref = BgpUpdate.parseAttributeTypeLocalPref(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 6: {
                    BgpUpdate.parseAttributeTypeAtomicAggregate(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    continue block13;
                }
                case 7: {
                    Pair<Long, Ip4Address> aggregator = BgpUpdate.parseAttributeTypeAggregator(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    aggregatorAsNumber = (Long)aggregator.getLeft();
                    aggregatorIpAddress = (Ip4Address)aggregator.getRight();
                    continue block13;
                }
                case 14: {
                    MpNlri mpNlriReach = BgpUpdate.parseAttributeTypeMpReachNlri(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    if (mpNlriReach == null) continue block13;
                    mpNlriReachList.add(mpNlriReach);
                    continue block13;
                }
                case 15: {
                    MpNlri mpNlriUnreach = BgpUpdate.parseAttributeTypeMpUnreachNlri(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                    if (mpNlriUnreach == null) continue block13;
                    mpNlriUnreachList.add(mpNlriUnreach);
                    continue block13;
                }
            }
            if (!optionalBit) {
                BgpUpdate.actionsBgpUpdateUnrecognizedWellKnownAttribute(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
                String errorMsg3 = "Unrecognized Well-known Attribute: " + attrTypeCode;
                throw new BgpMessage.BgpParseException(errorMsg3);
            }
            log.debug("BGP RX UPDATE message from {}: Unrecognized Attribute Type {}", (Object)bgpSession.remoteInfo().address(), (Object)attrTypeCode);
            message.skipBytes(attrLen);
        }
        int nlriLength = message.readableBytes();
        try {
            Collection<Ip4Prefix> addedPrefixes4 = BgpUpdate.parsePackedIp4Prefixes(nlriLength, message);
            legacyNlri.nlri4 = addedPrefixes4;
        }
        catch (BgpMessage.BgpParseException e) {
            log.debug("Exception parsing NLRI from BGP peer {}: ", (Object)bgpSession.remoteInfo().bgpId(), (Object)e);
            BgpUpdate.actionsBgpUpdateInvalidNetworkField(bgpSession, ctx);
            throw e;
        }
        BgpUpdate.verifyBgpUpdateWellKnownAttributes(bgpSession, ctx, origin, asPath, localPref, legacyNlri, mpNlriReachList);
        for (MpNlri mpNlri : mpNlriUnreachList) {
            BgpRouteEntry bgpRouteEntry;
            for (Ip4Prefix prefix : mpNlri.nlri4) {
                bgpRouteEntry = bgpSession.findBgpRoute(prefix);
                if (bgpRouteEntry == null) continue;
                decodedBgpRoutes.deletedUnicastRoutes4.put(prefix, bgpRouteEntry);
            }
            for (Ip4Prefix prefix : mpNlri.nlri6) {
                bgpRouteEntry = bgpSession.findBgpRoute((Ip6Prefix)prefix);
                if (bgpRouteEntry == null) continue;
                decodedBgpRoutes.deletedUnicastRoutes6.put(prefix, bgpRouteEntry);
            }
        }
        mpNlriReachList.add(legacyNlri);
        for (MpNlri mpNlri : mpNlriReachList) {
            BgpRouteEntry bgpRouteEntry;
            for (Ip4Prefix prefix : mpNlri.nlri4) {
                bgpRouteEntry = new BgpRouteEntry(bgpSession, (IpPrefix)prefix, (IpAddress)mpNlri.nextHop4, origin.byteValue(), asPath, localPref);
                bgpRouteEntry.setMultiExitDisc(multiExitDisc);
                if (bgpRouteEntry.hasAsPathLoop(bgpSession.localInfo().asNumber())) {
                    log.debug("BGP RX UPDATE message IGNORED from {}: {} nextHop {}: contains AS Path loop", new Object[]{bgpSession.remoteInfo().address(), prefix, mpNlri.nextHop4});
                    continue;
                }
                log.debug("BGP RX UPDATE message ADDED from {}: {} nextHop {}", new Object[]{bgpSession.remoteInfo().address(), prefix, mpNlri.nextHop4});
                decodedBgpRoutes.deletedUnicastRoutes4.remove(prefix);
                decodedBgpRoutes.addedUnicastRoutes4.put(prefix, bgpRouteEntry);
            }
            for (Ip4Prefix prefix : mpNlri.nlri6) {
                bgpRouteEntry = new BgpRouteEntry(bgpSession, (IpPrefix)prefix, (IpAddress)mpNlri.nextHop6, origin.byteValue(), asPath, localPref);
                bgpRouteEntry.setMultiExitDisc(multiExitDisc);
                if (bgpRouteEntry.hasAsPathLoop(bgpSession.localInfo().asNumber())) {
                    log.debug("BGP RX UPDATE message IGNORED from {}: {} nextHop {}: contains AS Path loop", new Object[]{bgpSession.remoteInfo().address(), prefix, mpNlri.nextHop6});
                    continue;
                }
                log.debug("BGP RX UPDATE message ADDED from {}: {} nextHop {}", new Object[]{bgpSession.remoteInfo().address(), prefix, mpNlri.nextHop6});
                decodedBgpRoutes.deletedUnicastRoutes6.remove(prefix);
                decodedBgpRoutes.addedUnicastRoutes6.put(prefix, bgpRouteEntry);
            }
        }
    }

    private static void verifyBgpUpdateWellKnownAttributes(BgpSession bgpSession, ChannelHandlerContext ctx, Short origin, BgpRouteEntry.AsPath asPath, Long localPref, MpNlri legacyNlri, Collection<MpNlri> mpNlriReachList) throws BgpMessage.BgpParseException {
        boolean hasNlri = false;
        boolean hasLegacyNlri = false;
        if (!bgpSession.mpExtensions()) {
            hasNlri = true;
            hasLegacyNlri = true;
        } else {
            if (!legacyNlri.nlri4.isEmpty()) {
                hasNlri = true;
                hasLegacyNlri = true;
            }
            if (!mpNlriReachList.isEmpty()) {
                hasNlri = true;
            }
        }
        if (hasNlri && (origin == null || origin == -1)) {
            int type = 1;
            BgpUpdate.actionsBgpUpdateMissingWellKnownAttribute(bgpSession, ctx, type);
            String errorMsg = "Missing Well-known Attribute: ORIGIN";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (hasNlri && asPath == null) {
            int type = 2;
            BgpUpdate.actionsBgpUpdateMissingWellKnownAttribute(bgpSession, ctx, type);
            String errorMsg = "Missing Well-known Attribute: AS_PATH";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (hasNlri && localPref == null) {
            int type = 5;
            BgpUpdate.actionsBgpUpdateMissingWellKnownAttribute(bgpSession, ctx, type);
            String errorMsg = "Missing Well-known Attribute: LOCAL_PREF";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (hasLegacyNlri && legacyNlri.nextHop4 == null) {
            int type = 3;
            BgpUpdate.actionsBgpUpdateMissingWellKnownAttribute(bgpSession, ctx, type);
            String errorMsg = "Missing Well-known Attribute: NEXT_HOP";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
    }

    private static void verifyBgpUpdateAttributeFlags(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        boolean partialBit;
        String typeName = "UNKNOWN";
        boolean isWellKnown = false;
        switch (attrTypeCode) {
            case 1: {
                isWellKnown = true;
                typeName = "ORIGIN";
                break;
            }
            case 2: {
                isWellKnown = true;
                typeName = "AS_PATH";
                break;
            }
            case 3: {
                isWellKnown = true;
                typeName = "NEXT_HOP";
                break;
            }
            case 4: {
                isWellKnown = false;
                typeName = "MULTI_EXIT_DISC";
                break;
            }
            case 5: {
                isWellKnown = true;
                typeName = "LOCAL_PREF";
                break;
            }
            case 6: {
                isWellKnown = true;
                typeName = "ATOMIC_AGGREGATE";
                break;
            }
            case 7: {
                isWellKnown = false;
                typeName = "AGGREGATOR";
                break;
            }
            case 14: {
                isWellKnown = false;
                typeName = "MP_REACH_NLRI";
                break;
            }
            case 15: {
                isWellKnown = false;
                typeName = "MP_UNREACH_NLRI";
                break;
            }
            default: {
                isWellKnown = false;
                typeName = "UNKNOWN(" + attrTypeCode + ")";
            }
        }
        boolean optionalBit = (0x80 & attrFlags) != 0;
        boolean transitiveBit = (0x40 & attrFlags) != 0;
        boolean bl = partialBit = (0x20 & attrFlags) != 0;
        if (isWellKnown && optionalBit || isWellKnown && !transitiveBit || isWellKnown && partialBit || optionalBit && !transitiveBit && partialBit) {
            BgpUpdate.actionsBgpUpdateAttributeFlagsError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Flags Error for " + typeName + ": " + attrFlags;
            throw new BgpMessage.BgpParseException(errorMsg);
        }
    }

    private static short parseAttributeTypeOrigin(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        if (attrLen != 1) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        message.markReaderIndex();
        short origin = message.readUnsignedByte();
        switch (origin) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                message.resetReaderIndex();
                BgpUpdate.actionsBgpUpdateInvalidOriginAttribute(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message, origin);
                String errorMsg = "Invalid ORIGIN Attribute: " + origin;
                throw new BgpMessage.BgpParseException(errorMsg);
            }
        }
        return origin;
    }

    private static BgpRouteEntry.AsPath parseAttributeTypeAsPath(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        while (attrLen > 0) {
            if (attrLen < 2) {
                BgpUpdate.actionsBgpUpdateMalformedAsPath(bgpSession, ctx);
                String errorMsg = "Malformed AS Path";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            short pathSegmentType = message.readUnsignedByte();
            short pathSegmentLength = message.readUnsignedByte();
            attrLen -= 2;
            switch (pathSegmentType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    BgpUpdate.actionsBgpUpdateMalformedAsPath(bgpSession, ctx);
                    String errorMsg = "Invalid AS Path Segment Type: " + pathSegmentType;
                    throw new BgpMessage.BgpParseException(errorMsg);
                }
            }
            int asPathLen = bgpSession.isAs4OctetCapable() ? 4 : 2;
            if (asPathLen * pathSegmentLength > attrLen) {
                BgpUpdate.actionsBgpUpdateMalformedAsPath(bgpSession, ctx);
                String errorMsg = "Malformed AS Path";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            attrLen -= asPathLen * pathSegmentLength;
            ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
            while (true) {
                short s = pathSegmentLength;
                pathSegmentLength = (short)(pathSegmentLength - 1);
                if (s <= 0) break;
                long asNumber = asPathLen == 4 ? message.readUnsignedInt() : (long)message.readUnsignedShort();
                segmentAsNumbers.add(asNumber);
            }
            BgpRouteEntry.PathSegment pathSegment = new BgpRouteEntry.PathSegment((byte)pathSegmentType, segmentAsNumbers);
            pathSegments.add(pathSegment);
        }
        return new BgpRouteEntry.AsPath(pathSegments);
    }

    private static Ip4Address parseAttributeTypeNextHop(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        if (attrLen != 4) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        message.markReaderIndex();
        Ip4Address nextHopAddress = Ip4Address.valueOf((int)((int)message.readUnsignedInt()));
        if (nextHopAddress.equals((Object)bgpSession.localInfo().ip4Address())) {
            message.resetReaderIndex();
            BgpUpdate.actionsBgpUpdateInvalidNextHopAttribute(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message, nextHopAddress);
            String errorMsg = "Invalid NEXT_HOP Attribute: " + nextHopAddress;
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        return nextHopAddress;
    }

    private static long parseAttributeTypeMultiExitDisc(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        if (attrLen != 4) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        long multiExitDisc = message.readUnsignedInt();
        return multiExitDisc;
    }

    private static long parseAttributeTypeLocalPref(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        if (attrLen != 4) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        long localPref = message.readUnsignedInt();
        return localPref;
    }

    private static void parseAttributeTypeAtomicAggregate(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        if (attrLen != 0) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
    }

    private static Pair<Long, Ip4Address> parseAttributeTypeAggregator(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        int expectedAttrLen = bgpSession.isAs4OctetCapable() ? 8 : 6;
        if (attrLen != expectedAttrLen) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        long aggregatorAsNumber = bgpSession.isAs4OctetCapable() ? message.readUnsignedInt() : (long)message.readUnsignedShort();
        Ip4Address aggregatorIpAddress = Ip4Address.valueOf((int)((int)message.readUnsignedInt()));
        Pair aggregator = Pair.of((Object)aggregatorAsNumber, (Object)aggregatorIpAddress);
        return aggregator;
    }

    private static MpNlri parseAttributeTypeMpReachNlri(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        int attributeEnd = message.readerIndex() + attrLen;
        if (attrLen < 5) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        message.markReaderIndex();
        int afi = message.readUnsignedShort();
        short safi = message.readUnsignedByte();
        short nextHopLen = message.readUnsignedByte();
        if (afi != 1 && afi != 2 || safi != 1) {
            message.resetReaderIndex();
            message.skipBytes(attrLen);
            return null;
        }
        short expectedNextHopLen = 0;
        switch (afi) {
            case 1: {
                expectedNextHopLen = 4;
                break;
            }
            case 2: {
                expectedNextHopLen = 16;
                break;
            }
        }
        if (nextHopLen != expectedNextHopLen) {
            message.resetReaderIndex();
            BgpUpdate.actionsBgpUpdateOptionalAttributeError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Invalid next-hop network address length. Received " + nextHopLen + " expected " + expectedNextHopLen;
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (message.readerIndex() + nextHopLen + 1 >= attributeEnd) {
            message.resetReaderIndex();
            BgpUpdate.actionsBgpUpdateOptionalAttributeError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Malformed next-hop network address";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        byte[] nextHopBuffer = new byte[nextHopLen];
        message.readBytes(nextHopBuffer, 0, (int)nextHopLen);
        short reserved = message.readUnsignedByte();
        MpNlri mpNlri = new MpNlri(afi, safi);
        try {
            switch (afi) {
                case 1: {
                    mpNlri.nextHop4 = Ip4Address.valueOf((byte[])nextHopBuffer);
                    mpNlri.nlri4 = BgpUpdate.parsePackedIp4Prefixes(attributeEnd - message.readerIndex(), message);
                    break;
                }
                case 2: {
                    mpNlri.nextHop6 = Ip6Address.valueOf((byte[])nextHopBuffer);
                    mpNlri.nlri6 = BgpUpdate.parsePackedIp6Prefixes(attributeEnd - message.readerIndex(), message);
                    break;
                }
            }
        }
        catch (BgpMessage.BgpParseException e) {
            message.resetReaderIndex();
            BgpUpdate.actionsBgpUpdateOptionalAttributeError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Malformed network layer reachability information";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        return mpNlri;
    }

    private static MpNlri parseAttributeTypeMpUnreachNlri(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) throws BgpMessage.BgpParseException {
        int attributeEnd = message.readerIndex() + attrLen;
        if (attrLen < 3) {
            BgpUpdate.actionsBgpUpdateAttributeLengthError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Attribute Length Error";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        message.markReaderIndex();
        int afi = message.readUnsignedShort();
        short safi = message.readUnsignedByte();
        if (afi != 1 && afi != 2 || safi != 1) {
            message.resetReaderIndex();
            message.skipBytes(attrLen);
            return null;
        }
        MpNlri mpNlri = new MpNlri(afi, safi);
        try {
            switch (afi) {
                case 1: {
                    mpNlri.nlri4 = BgpUpdate.parsePackedIp4Prefixes(attributeEnd - message.readerIndex(), message);
                    break;
                }
                case 2: {
                    mpNlri.nlri6 = BgpUpdate.parsePackedIp6Prefixes(attributeEnd - message.readerIndex(), message);
                    break;
                }
            }
        }
        catch (BgpMessage.BgpParseException e) {
            message.resetReaderIndex();
            BgpUpdate.actionsBgpUpdateOptionalAttributeError(bgpSession, ctx, attrTypeCode, attrLen, attrFlags, message);
            String errorMsg = "Malformed withdrawn routes";
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        return mpNlri;
    }

    private static Collection<Ip4Prefix> parsePackedIp4Prefixes(int totalLength, ChannelBuffer message) throws BgpMessage.BgpParseException {
        ArrayList<Ip4Prefix> result = new ArrayList<Ip4Prefix>();
        if (totalLength == 0) {
            return result;
        }
        byte[] buffer = new byte[4];
        int dataEnd = message.readerIndex() + totalLength;
        while (message.readerIndex() < dataEnd) {
            short prefixBitlen = message.readUnsignedByte();
            int prefixBytelen = (prefixBitlen + 7) / 8;
            if (message.readerIndex() + prefixBytelen > dataEnd) {
                String errorMsg = "Malformed Network Prefixes";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            message.readBytes(buffer, 0, prefixBytelen);
            Ip4Prefix prefix = Ip4Prefix.valueOf((Ip4Address)Ip4Address.valueOf((byte[])buffer), (int)prefixBitlen);
            result.add(prefix);
        }
        return result;
    }

    private static Collection<Ip6Prefix> parsePackedIp6Prefixes(int totalLength, ChannelBuffer message) throws BgpMessage.BgpParseException {
        ArrayList<Ip6Prefix> result = new ArrayList<Ip6Prefix>();
        if (totalLength == 0) {
            return result;
        }
        byte[] buffer = new byte[16];
        int dataEnd = message.readerIndex() + totalLength;
        while (message.readerIndex() < dataEnd) {
            short prefixBitlen = message.readUnsignedByte();
            int prefixBytelen = (prefixBitlen + 7) / 8;
            if (message.readerIndex() + prefixBytelen > dataEnd) {
                String errorMsg = "Malformed Network Prefixes";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            message.readBytes(buffer, 0, prefixBytelen);
            Ip6Prefix prefix = Ip6Prefix.valueOf((Ip6Address)Ip6Address.valueOf((byte[])buffer), (int)prefixBitlen);
            result.add(prefix);
        }
        return result;
    }

    private static void actionsBgpUpdateInvalidNetworkField(BgpSession bgpSession, ChannelHandlerContext ctx) {
        log.debug("BGP RX UPDATE Error from {}: Invalid Network Field", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 10;
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateMalformedAttributeList(BgpSession bgpSession, ChannelHandlerContext ctx) {
        log.debug("BGP RX UPDATE Error from {}: Malformed Attribute List", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 1;
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateMissingWellKnownAttribute(BgpSession bgpSession, ChannelHandlerContext ctx, int missingAttrTypeCode) {
        log.debug("BGP RX UPDATE Error from {}: Missing Well-known Attribute: {}", (Object)bgpSession.remoteInfo().address(), (Object)missingAttrTypeCode);
        int errorCode = 3;
        int errorSubcode = 3;
        ChannelBuffer data = ChannelBuffers.buffer((int)1);
        data.writeByte(missingAttrTypeCode);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateInvalidOriginAttribute(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message, short origin) {
        log.debug("BGP RX UPDATE Error from {}: Invalid ORIGIN Attribute", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 6;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateAttributeFlagsError(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) {
        log.debug("BGP RX UPDATE Error from {}: Attribute Flags Error", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 4;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateInvalidNextHopAttribute(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message, Ip4Address nextHop) {
        log.debug("BGP RX UPDATE Error from {}: Invalid NEXT_HOP Attribute {}", (Object)bgpSession.remoteInfo().address(), (Object)nextHop);
        int errorCode = 3;
        int errorSubcode = 8;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateUnrecognizedWellKnownAttribute(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) {
        log.debug("BGP RX UPDATE Error from {}: Unrecognized Well-known Attribute Error: {}", (Object)bgpSession.remoteInfo().address(), (Object)attrTypeCode);
        int errorCode = 3;
        int errorSubcode = 2;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateOptionalAttributeError(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) {
        log.debug("BGP RX UPDATE Error from {}: Optional Attribute Error: {}", (Object)bgpSession.remoteInfo().address(), (Object)attrTypeCode);
        int errorCode = 3;
        int errorSubcode = 9;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateAttributeLengthError(BgpSession bgpSession, ChannelHandlerContext ctx, int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) {
        log.debug("BGP RX UPDATE Error from {}: Attribute Length Error", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 5;
        ChannelBuffer data = BgpUpdate.prepareBgpUpdateNotificationDataPayload(attrTypeCode, attrLen, attrFlags, message);
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static void actionsBgpUpdateMalformedAsPath(BgpSession bgpSession, ChannelHandlerContext ctx) {
        log.debug("BGP RX UPDATE Error from {}: Malformed AS Path", (Object)bgpSession.remoteInfo().address());
        int errorCode = 3;
        int errorSubcode = 11;
        ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
        ctx.getChannel().write((Object)txMessage);
        bgpSession.closeSession(ctx);
    }

    private static ChannelBuffer prepareBgpUpdateNotificationDataPayload(int attrTypeCode, int attrLen, int attrFlags, ChannelBuffer message) {
        boolean extendedLengthBit = (0x10 & attrFlags) != 0;
        int attrLenOctets = 1;
        if (extendedLengthBit) {
            attrLenOctets = 2;
        }
        ChannelBuffer data = ChannelBuffers.buffer((int)(attrLen + attrLenOctets + 1));
        data.writeByte(attrTypeCode);
        if (extendedLengthBit) {
            data.writeShort(attrLen);
        } else {
            data.writeByte(attrLen);
        }
        data.writeBytes(message, attrLen);
        return data;
    }

    private static final class DecodedBgpRoutes {
        private final Map<Ip4Prefix, BgpRouteEntry> addedUnicastRoutes4 = new HashMap<Ip4Prefix, BgpRouteEntry>();
        private final Map<Ip6Prefix, BgpRouteEntry> addedUnicastRoutes6 = new HashMap<Ip6Prefix, BgpRouteEntry>();
        private final Map<Ip4Prefix, BgpRouteEntry> deletedUnicastRoutes4 = new HashMap<Ip4Prefix, BgpRouteEntry>();
        private final Map<Ip6Prefix, BgpRouteEntry> deletedUnicastRoutes6 = new HashMap<Ip6Prefix, BgpRouteEntry>();

        private DecodedBgpRoutes() {
        }
    }

    private static final class MpNlri {
        private final int afi;
        private final int safi;
        private Ip4Address nextHop4;
        private Ip6Address nextHop6;
        private Collection<Ip4Prefix> nlri4 = new ArrayList<Ip4Prefix>();
        private Collection<Ip6Prefix> nlri6 = new ArrayList<Ip6Prefix>();

        private MpNlri(int afi, int safi) {
            this.afi = afi;
            this.safi = safi;
        }
    }
}

