/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.config.BgpConfig;

@Command(scope="onos", name="add-bgp-peer", description="Adds an external BGP router as peer to an existing BGP speaker")
public class AddPeerCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="Name of the internal BGP speaker", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="ip", description="IP address of the BGP peer", required=true, multiValued=false)
    String ip = null;
    private static final String PEER_ADD_SUCCESS = "Peer Successfully Added.";
    private static final String NO_CONFIGURATION = "No speakers configured";
    private static final String SPEAKER_NOT_FOUND = "Speaker with name '%s' not found";
    private static final String NO_INTERFACE = "No matching interface found for IP '%s'";
    private IpAddress peerAddress = null;

    protected void execute() {
        CoreService coreService;
        ApplicationId appId;
        this.peerAddress = IpAddress.valueOf((String)this.ip);
        NetworkConfigService configService = (NetworkConfigService)AddPeerCommand.get(NetworkConfigService.class);
        BgpConfig config = (BgpConfig)configService.getConfig((Object)(appId = (coreService = (CoreService)AddPeerCommand.get(CoreService.class)).getAppId("org.onosproject.router")), BgpConfig.class);
        if (config == null || config.bgpSpeakers().isEmpty()) {
            this.print(NO_CONFIGURATION, new Object[0]);
            return;
        }
        BgpConfig.BgpSpeakerConfig speaker = config.getSpeakerWithName(this.name);
        if (speaker == null) {
            this.print(SPEAKER_NOT_FOUND, new Object[]{this.name});
            return;
        }
        if (speaker.isConnectedToPeer(this.peerAddress)) {
            return;
        }
        InterfaceService interfaceService = (InterfaceService)AddPeerCommand.get(InterfaceService.class);
        if (interfaceService.getMatchingInterface(this.peerAddress) == null) {
            this.print(NO_INTERFACE, new Object[]{this.ip});
            return;
        }
        this.addPeerToSpeakerConf(config);
        configService.applyConfig((Object)appId, BgpConfig.class, config.node());
        this.print(PEER_ADD_SUCCESS, new Object[0]);
    }

    private void addPeerToSpeakerConf(BgpConfig config) {
        this.log.debug("Creating BGP configuration for new peer: {}", (Object)this.ip);
        config.addPeerToSpeaker(this.name, this.peerAddress);
    }
}

