/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.config.BgpConfig;

@Command(scope="onos", name="remove-bgp-peer", description="Removes a BGP peer")
public class RemovePeerCommand
extends AbstractShellCommand {
    @Argument(index=0, name="ip", description="IP address of the BGP peer", required=true, multiValued=false)
    String ip = null;
    private static final String PEER_REMOVE_SUCCESS = "Peer Successfully Removed.";
    private static final String NO_CONFIGURATION = "No speakers configured";
    private static final String PEER_NOT_FOUND = "Peer with IP '%s' not found";
    private IpAddress peerAddress = null;

    protected void execute() {
        CoreService coreService;
        ApplicationId appId;
        this.peerAddress = IpAddress.valueOf((String)this.ip);
        NetworkConfigService configService = (NetworkConfigService)RemovePeerCommand.get(NetworkConfigService.class);
        BgpConfig config = (BgpConfig)configService.getConfig((Object)(appId = (coreService = (CoreService)RemovePeerCommand.get(CoreService.class)).getAppId("org.onosproject.router")), BgpConfig.class);
        if (config == null || config.bgpSpeakers().isEmpty()) {
            this.print(NO_CONFIGURATION, new Object[0]);
            return;
        }
        this.peerAddress = IpAddress.valueOf((String)this.ip);
        BgpConfig.BgpSpeakerConfig speaker = config.getSpeakerFromPeer(this.peerAddress);
        if (speaker == null) {
            this.print(PEER_NOT_FOUND, new Object[]{this.ip});
            return;
        }
        this.removePeerFromSpeakerConf(speaker, config);
        configService.applyConfig((Object)appId, BgpConfig.class, config.node());
        this.print(PEER_REMOVE_SUCCESS, new Object[0]);
    }

    private void removePeerFromSpeakerConf(BgpConfig.BgpSpeakerConfig speaker, BgpConfig config) {
        this.log.debug("Removing BGP configuration for peer: {}", (Object)this.ip);
        config.removePeerFromSpeaker(speaker, this.peerAddress);
    }
}

