/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.config.BgpConfig;

@Command(scope="onos", name="remove-bgp-speaker", description="Removes an internal BGP speaker")
public class RemoveSpeakerCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="Name of the internal BGP speaker", required=true, multiValued=false)
    String name = null;
    private static final String SPEAKER_REMOVE_SUCCESS = "Speaker Successfully Removed.";
    private static final String NO_CONFIGURATION = "No speakers configured";
    private static final String PEERS_EXIST = "Speaker with name '%s' has peer connections";
    private static final String SPEAKER_NOT_FOUND = "Speaker with name '%s' not found";

    protected void execute() {
        CoreService coreService;
        ApplicationId appId;
        NetworkConfigService configService = (NetworkConfigService)RemoveSpeakerCommand.get(NetworkConfigService.class);
        BgpConfig config = (BgpConfig)configService.getConfig((Object)(appId = (coreService = (CoreService)RemoveSpeakerCommand.get(CoreService.class)).getAppId("org.onosproject.router")), BgpConfig.class);
        if (config == null || config.bgpSpeakers().isEmpty()) {
            this.print(NO_CONFIGURATION, new Object[0]);
            return;
        }
        BgpConfig.BgpSpeakerConfig speaker = config.getSpeakerWithName(this.name);
        if (speaker == null) {
            this.print(SPEAKER_NOT_FOUND, new Object[]{this.name});
            return;
        }
        if (!speaker.peers().isEmpty()) {
            this.print(PEERS_EXIST, new Object[]{this.name});
            return;
        }
        this.removeSpeakerFromConf(config);
        configService.applyConfig((Object)appId, BgpConfig.class, config.node());
        this.print(SPEAKER_REMOVE_SUCCESS, new Object[0]);
    }

    private void removeSpeakerFromConf(BgpConfig bgpConfig) {
        this.log.debug("Removing speaker from configuration: {}", (Object)this.name);
        bgpConfig.removeSpeaker(this.name);
    }
}

