/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RouteAttributeDecoder;

public final class RouteAttributePriority
extends RouteAttribute {
    private static final int VALUE_LENGTH = 4;
    private final long priority;

    private RouteAttributePriority(int length, int type, long priority) {
        super(length, type);
        this.priority = priority;
    }

    public long priority() {
        return this.priority;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", this.type()).add("length", this.length()).add("priority", this.priority).toString();
    }

    public static RouteAttributeDecoder<RouteAttributePriority> decoder() {
        return (length, type, value) -> {
            if (value.length != 4) {
                throw new DeserializationException("Wrong value length");
            }
            long priority = Integer.reverseBytes(ByteBuffer.wrap(value).getInt());
            return new RouteAttributePriority(length, type, priority);
        };
    }
}

