/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.host.HostService;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.BgpConfig;

@Component(immediate=true, enabled=false)
public class BgpSpeakerNeighbourHandler {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NeighbourResolutionService neighbourService;
    private ApplicationId appId;
    private Set<ConnectPoint> speakerConnectPoints = new HashSet<ConnectPoint>();
    private InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private ExternalInterfaceNeighbourHandler externalHandler = new ExternalInterfaceNeighbourHandler();
    private InternalSpeakerNeighbourHandler internalHandler = new InternalSpeakerNeighbourHandler();

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.router");
        this.configService.addListener((EventListener)this.configListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.interfaceService.getInterfaces().forEach(intf -> this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.externalHandler, this.appId));
        this.configureSpeakerHandlers();
    }

    @Deactivate
    protected void deactivate() {
        this.configService.removeListener((EventListener)this.configListener);
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
    }

    private void configureSpeakerHandlers() {
        BgpConfig config = (BgpConfig)this.configService.getConfig((Object)this.appId, RoutingService.CONFIG_CLASS);
        if (config == null) {
            return;
        }
        this.speakerConnectPoints.forEach(cp -> this.neighbourService.unregisterNeighbourHandler(cp, (NeighbourMessageHandler)this.internalHandler, this.appId));
        this.speakerConnectPoints.clear();
        config.bgpSpeakers().forEach(speaker -> {
            this.neighbourService.registerNeighbourHandler(speaker.connectPoint(), (NeighbourMessageHandler)this.internalHandler, this.appId);
            this.speakerConnectPoints.add(speaker.connectPoint());
        });
    }

    private void updateInterface(Interface intf) {
        if (!intf.ipAddresses().isEmpty()) {
            this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.externalHandler, this.appId);
        }
    }

    private void removeInterface(Interface intf) {
        this.neighbourService.unregisterNeighbourHandler(intf, (NeighbourMessageHandler)this.externalHandler, this.appId);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourService = neighbourResolutionService;
    }

    protected void unbindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourService == neighbourResolutionService) {
            this.neighbourService = null;
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    BgpSpeakerNeighbourHandler.this.updateInterface((Interface)event.subject());
                    break;
                }
                case INTERFACE_UPDATED: {
                    break;
                }
                case INTERFACE_REMOVED: {
                    BgpSpeakerNeighbourHandler.this.removeInterface((Interface)event.subject());
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_REGISTERED: {
                    break;
                }
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: 
                case CONFIG_REMOVED: {
                    if (event.configClass() != RoutingService.CONFIG_CLASS) break;
                    BgpSpeakerNeighbourHandler.this.configureSpeakerHandlers();
                    break;
                }
            }
        }
    }

    private class InternalSpeakerNeighbourHandler
    implements NeighbourMessageHandler {
        private InternalSpeakerNeighbourHandler() {
        }

        public void handleMessage(NeighbourMessageContext context, HostService hostService) {
            BgpSpeakerNeighbourHandler.this.interfaceService.getInterfacesByIp(context.sender()).stream().filter(intf -> intf.vlan().equals((Object)context.vlan())).map(intf -> intf.connectPoint()).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        }
    }

    public class ExternalInterfaceNeighbourHandler
    implements NeighbourMessageHandler {
        public void handleMessage(NeighbourMessageContext context, HostService hostService) {
            switch (context.type()) {
                case REQUEST: {
                    BgpSpeakerNeighbourHandler.this.interfaceService.getInterfacesByPort(context.inPort()).stream().filter(intf -> intf.ipAddresses().stream().anyMatch(ia -> ia.ipAddress().equals((Object)context.target()) && ia.subnetAddress().contains(context.sender()))).forEach(intf -> context.reply(intf.mac()));
                    break;
                }
                case REPLY: {
                    Host h = hostService.getHost(HostId.hostId((MacAddress)context.dstMac(), (VlanId)context.vlan()));
                    if (h == null) {
                        context.drop();
                        break;
                    }
                    context.forward((ConnectPoint)h.location());
                    break;
                }
            }
        }
    }
}

