/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.EthType;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
public class ControlPlaneRedirectManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MIN_IP_PRIORITY = 10;
    private static final int ACL_PRIORITY = 40001;
    private static final int OSPF_IP_PROTO = 89;
    private static final String APP_NAME = "org.onosproject.vrouter";
    private ApplicationId appId;
    private ConnectPoint controlPlaneConnectPoint;
    private boolean ospfEnabled = false;
    private List<String> interfaces = Collections.emptyList();
    private Map<Host, Set<Integer>> peerNextId = Maps.newConcurrentMap();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    private final InternalDeviceListener deviceListener = new InternalDeviceListener();
    private final InternalNetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    private final InternalHostListener hostListener = new InternalHostListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.readConfig();
        this.applicationService.registerDeactivateHook(this.appId, () -> this.provisionDevice(false));
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
    }

    private void readConfig() {
        ApplicationId routingAppId = this.coreService.registerApplication("org.onosproject.router");
        RouterConfig config = (RouterConfig)this.networkConfigService.getConfig((Object)routingAppId, RoutingService.ROUTER_CONFIG_CLASS);
        if (config == null) {
            this.log.warn("Router config not available");
            return;
        }
        this.controlPlaneConnectPoint = config.getControlPlaneConnectPoint();
        this.ospfEnabled = config.getOspfEnabled();
        this.interfaces = config.getInterfaces();
        this.provisionDevice(true);
    }

    private void provisionDevice(boolean install) {
        if (this.controlPlaneConnectPoint != null && this.deviceService.isAvailable(this.controlPlaneConnectPoint.deviceId())) {
            DeviceId deviceId = this.controlPlaneConnectPoint.deviceId();
            this.interfaceService.getInterfaces().stream().filter(intf -> intf.connectPoint().deviceId().equals((Object)deviceId)).filter(intf -> this.interfaces.isEmpty() || this.interfaces.contains(intf.name())).forEach(intf -> this.provisionInterface((Interface)intf, install));
            this.log.info("Set up interfaces on {}", (Object)this.controlPlaneConnectPoint.deviceId());
        }
    }

    private void provisionInterface(Interface intf, boolean install) {
        this.updateInterfaceForwarding(intf, install);
        this.updateOspfForwarding(intf, install);
    }

    private void updateInterfaceForwarding(Interface intf, boolean install) {
        this.log.debug("Adding interface objectives for {}", (Object)intf);
        DeviceId deviceId = this.controlPlaneConnectPoint.deviceId();
        PortNumber controlPlanePort = this.controlPlaneConnectPoint.port();
        for (InterfaceIpAddress ip : intf.ipAddresses()) {
            int intfNextId;
            int cpNextId;
            if (intf.vlan() == VlanId.NONE) {
                cpNextId = this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install);
                intfNextId = this.modifyNextObjective(deviceId, intf.connectPoint().port(), VlanId.vlanId((short)4094), true, install);
            } else {
                cpNextId = this.modifyNextObjective(deviceId, controlPlanePort, intf.vlan(), false, install);
                intfNextId = this.modifyNextObjective(deviceId, intf.connectPoint().port(), intf.vlan(), false, install);
            }
            TrafficSelector toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthDst(intf.mac()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchVlanId(intf.vlan()).matchIPDst(ip.ipAddress().toIpPrefix()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(toSelector, null, cpNextId, install));
            TrafficSelector fromSelector = DefaultTrafficSelector.builder().matchInPort(controlPlanePort).matchEthSrc(intf.mac()).matchVlanId(intf.vlan()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchIPSrc(ip.ipAddress().toIpPrefix()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(fromSelector, null, intfNextId, install));
            toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthType(EthType.EtherType.ARP.ethType().toShort()).matchVlanId(intf.vlan()).build();
            TrafficTreatment puntTreatment = DefaultTrafficTreatment.builder().punt().build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(toSelector, puntTreatment, cpNextId, install));
            fromSelector = DefaultTrafficSelector.builder().matchInPort(controlPlanePort).matchEthSrc(intf.mac()).matchVlanId(intf.vlan()).matchEthType(EthType.EtherType.ARP.ethType().toShort()).matchArpSpa(ip.ipAddress().getIp4Address()).build();
            this.flowObjectiveService.forward(deviceId, this.buildForwardingObjective(fromSelector, puntTreatment, intfNextId, install));
        }
    }

    private void updateOspfForwarding(Interface intf, boolean install) {
        TrafficSelector toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchVlanId(intf.vlan()).matchIPProtocol((byte)89).build();
        DeviceId deviceId = this.controlPlaneConnectPoint.deviceId();
        PortNumber controlPlanePort = this.controlPlaneConnectPoint.port();
        int cpNextId = intf.vlan() == VlanId.NONE ? this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install) : this.modifyNextObjective(deviceId, controlPlanePort, intf.vlan(), false, install);
        this.log.debug("OSPF flows intf:{} nextid:{}", (Object)intf, (Object)cpNextId);
        this.flowObjectiveService.forward(this.controlPlaneConnectPoint.deviceId(), this.buildForwardingObjective(toSelector, null, cpNextId, install ? this.ospfEnabled : install));
    }

    private int modifyNextObjective(DeviceId deviceId, PortNumber portNumber, VlanId vlanId, boolean popVlan, boolean install) {
        int nextId = this.flowObjectiveService.allocateNextId();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.SIMPLE).fromApp(this.appId);
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (popVlan) {
            ttBuilder.popVlan();
        }
        ttBuilder.setOutput(portNumber);
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
        metabuilder.matchVlanId(vlanId);
        nextObjBuilder.withMeta(metabuilder.build());
        nextObjBuilder.addTreatment(ttBuilder.build());
        this.log.debug("Submitted next objective {} in device {} for port/vlan {}/{}", new Object[]{nextId, deviceId, portNumber, vlanId});
        if (install) {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.add());
        } else {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.remove());
        }
        return nextId;
    }

    private ForwardingObjective buildForwardingObjective(TrafficSelector selector, TrafficTreatment treatment, int nextId, boolean add) {
        DefaultForwardingObjective.Builder fobBuilder = DefaultForwardingObjective.builder();
        fobBuilder.withSelector(selector);
        if (treatment != null) {
            fobBuilder.withTreatment(treatment);
        }
        if (nextId != -1) {
            fobBuilder.nextStep(nextId);
        }
        fobBuilder.fromApp(this.appId).withPriority(40001).withFlag(ForwardingObjective.Flag.VERSATILE);
        return add ? fobBuilder.add() : fobBuilder.remove();
    }

    private int getPriorityFromPrefix(IpPrefix prefix) {
        return prefix.isIp4() ? 2000 * prefix.prefixLength() + 10 : 500 * prefix.prefixLength() + 10;
    }

    private void updateInterface(Interface prevIntf, Interface intf) {
        if (!prevIntf.vlan().equals((Object)intf.vlan()) || !prevIntf.mac().equals((Object)intf)) {
            this.provisionInterface(prevIntf, false);
            this.provisionInterface(intf, true);
        } else {
            List removeIps = prevIntf.ipAddressesList().stream().filter(pre -> !intf.ipAddressesList().contains(pre)).collect(Collectors.toList());
            List addIps = intf.ipAddressesList().stream().filter(cur -> !prevIntf.ipAddressesList().contains(cur)).collect(Collectors.toList());
            this.updateInterfaceForwarding(new Interface(prevIntf.name(), prevIntf.connectPoint(), removeIps, prevIntf.mac(), prevIntf.vlan()), false);
            this.updateInterfaceForwarding(new Interface(intf.name(), intf.connectPoint(), addIps, intf.mac(), intf.vlan()), true);
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            if (ControlPlaneRedirectManager.this.controlPlaneConnectPoint == null) {
                ControlPlaneRedirectManager.this.log.info("Control plane connect point is not configured. Abort InterfaceEvent.");
                return;
            }
            Interface intf = (Interface)event.subject();
            Interface prevIntf = event.prevSubject();
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    if (intf == null || intf.connectPoint().equals((Object)ControlPlaneRedirectManager.this.controlPlaneConnectPoint)) break;
                    ControlPlaneRedirectManager.this.provisionInterface(intf, true);
                    break;
                }
                case INTERFACE_UPDATED: {
                    if (intf == null || intf.connectPoint().equals((Object)ControlPlaneRedirectManager.this.controlPlaneConnectPoint)) break;
                    ControlPlaneRedirectManager.this.updateInterface(prevIntf, intf);
                    break;
                }
                case INTERFACE_REMOVED: {
                    if (intf == null || intf.connectPoint().equals((Object)ControlPlaneRedirectManager.this.controlPlaneConnectPoint)) break;
                    ControlPlaneRedirectManager.this.provisionInterface(intf, false);
                    break;
                }
            }
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        private void peerAdded(HostEvent event) {
            Host peer = (Host)event.subject();
            Optional<Interface> peerIntf = ControlPlaneRedirectManager.this.interfaceService.getInterfacesByPort((ConnectPoint)peer.location()).stream().filter(intf -> ControlPlaneRedirectManager.this.interfaces.isEmpty() || ControlPlaneRedirectManager.this.interfaces.contains(intf.name())).filter(intf -> peer.vlan().equals((Object)intf.vlan())).findFirst();
            if (!peerIntf.isPresent()) {
                ControlPlaneRedirectManager.this.log.debug("Adding peer {}/{} on {} but the interface is not configured", new Object[]{peer.mac(), peer.vlan(), peer.location()});
                return;
            }
            int toRouterL3Unicast = this.createPeerGroup(peer.mac(), peerIntf.get().mac(), peer.vlan(), peer.location().deviceId(), ControlPlaneRedirectManager.this.controlPlaneConnectPoint.port());
            int toPeerL3Unicast = this.createPeerGroup(peerIntf.get().mac(), peer.mac(), peer.vlan(), peer.location().deviceId(), peer.location().port());
            ControlPlaneRedirectManager.this.peerNextId.put(peer, ImmutableSortedSet.of((Comparable)Integer.valueOf(toRouterL3Unicast), (Comparable)Integer.valueOf(toPeerL3Unicast)));
            peerIntf.get().ipAddresses().forEach(routerIp -> ControlPlaneRedirectManager.this.flowObjectiveService.forward(peer.location().deviceId(), this.createPeerObjBuilder(toRouterL3Unicast, routerIp.ipAddress().toIpPrefix()).add()));
            peer.ipAddresses().forEach(peerIp -> ControlPlaneRedirectManager.this.flowObjectiveService.forward(peer.location().deviceId(), this.createPeerObjBuilder(toPeerL3Unicast, peerIp.toIpPrefix()).add()));
        }

        private void peerRemoved(HostEvent event) {
            Host peer = (Host)event.subject();
            Optional<Interface> peerIntf = ControlPlaneRedirectManager.this.interfaceService.getInterfacesByPort((ConnectPoint)peer.location()).stream().filter(intf -> ControlPlaneRedirectManager.this.interfaces.isEmpty() || ControlPlaneRedirectManager.this.interfaces.contains(intf.name())).filter(intf -> peer.vlan().equals((Object)intf.vlan())).findFirst();
            if (!peerIntf.isPresent()) {
                ControlPlaneRedirectManager.this.log.debug("Removing peer {}/{} on {} but the interface is not configured", new Object[]{peer.mac(), peer.vlan(), peer.location()});
                return;
            }
            Preconditions.checkState((ControlPlaneRedirectManager.this.peerNextId.get(peer) != null ? 1 : 0) != 0, (Object)"Peer nextId should not be null");
            Preconditions.checkState((((Set)ControlPlaneRedirectManager.this.peerNextId.get(peer)).size() == 2 ? 1 : 0) != 0, (Object)"Wrong nextId associated with the peer");
            Iterator iter = ((Set)ControlPlaneRedirectManager.this.peerNextId.get(peer)).iterator();
            int toRouterL3Unicast = (Integer)iter.next();
            int toPeerL3Unicast = (Integer)iter.next();
            peerIntf.get().ipAddresses().forEach(routerIp -> ControlPlaneRedirectManager.this.flowObjectiveService.forward(peer.location().deviceId(), this.createPeerObjBuilder(toRouterL3Unicast, routerIp.ipAddress().toIpPrefix()).remove()));
            peer.ipAddresses().forEach(peerIp -> ControlPlaneRedirectManager.this.flowObjectiveService.forward(peer.location().deviceId(), this.createPeerObjBuilder(toPeerL3Unicast, peerIp.toIpPrefix()).remove()));
        }

        private ForwardingObjective.Builder createPeerObjBuilder(int nextId, IpPrefix ipAddresses) {
            TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
            sbuilder.matchEthType(EthType.EtherType.IPV4.ethType().toShort());
            sbuilder.matchIPDst(ipAddresses);
            DefaultForwardingObjective.Builder builder = DefaultForwardingObjective.builder().withSelector(sbuilder.build()).fromApp(ControlPlaneRedirectManager.this.appId).withPriority(ControlPlaneRedirectManager.this.getPriorityFromPrefix(ipAddresses)).withFlag(ForwardingObjective.Flag.SPECIFIC);
            if (nextId != -1) {
                builder.nextStep(nextId);
            }
            return builder;
        }

        private int createPeerGroup(MacAddress srcMac, MacAddress dstMac, VlanId vlanId, DeviceId deviceId, PortNumber port) {
            int nextId = ControlPlaneRedirectManager.this.flowObjectiveService.allocateNextId();
            DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.SIMPLE).fromApp(ControlPlaneRedirectManager.this.appId);
            TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
            ttBuilder.setEthSrc(srcMac);
            ttBuilder.setEthDst(dstMac);
            ttBuilder.setOutput(port);
            nextObjBuilder.addTreatment(ttBuilder.build());
            TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
            VlanId matchVlanId = vlanId.equals((Object)VlanId.NONE) ? VlanId.vlanId((short)4094) : vlanId;
            metabuilder.matchVlanId(matchVlanId);
            nextObjBuilder.withMeta(metabuilder.build());
            ControlPlaneRedirectManager.this.flowObjectiveService.next(deviceId, nextObjBuilder.add());
            return nextId;
        }

        public void event(HostEvent event) {
            DeviceId deviceId = ((Host)event.subject()).location().deviceId();
            if (!ControlPlaneRedirectManager.this.mastershipService.isLocalMaster(deviceId)) {
                return;
            }
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: {
                    this.peerAdded(event);
                    break;
                }
                case HOST_MOVED: {
                    break;
                }
                case HOST_REMOVED: {
                    this.peerRemoved(event);
                    break;
                }
                case HOST_UPDATED: {
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(RoutingService.ROUTER_CONFIG_CLASS)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: {
                        ControlPlaneRedirectManager.this.readConfig();
                        break;
                    }
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (ControlPlaneRedirectManager.this.controlPlaneConnectPoint != null && ((Device)event.subject()).id().equals((Object)ControlPlaneRedirectManager.this.controlPlaneConnectPoint.deviceId())) {
                switch ((DeviceEvent.Type)event.type()) {
                    case DEVICE_ADDED: 
                    case DEVICE_AVAILABILITY_CHANGED: {
                        if (!ControlPlaneRedirectManager.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                        ControlPlaneRedirectManager.this.log.info("Device connected {}", (Object)((Device)event.subject()).id());
                        ControlPlaneRedirectManager.this.provisionDevice(true);
                        break;
                    }
                }
            }
        }
    }
}

