/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.BgpSessionInfo;

public class BgpRouteEntryTest {
    private BgpSession bgpSession;
    private static final Ip4Address BGP_SESSION_BGP_ID = Ip4Address.valueOf((String)"10.0.0.1");
    private static final Ip4Address BGP_SESSION_IP_ADDRESS = Ip4Address.valueOf((String)"20.0.0.1");
    private BgpSession bgpSession2;
    private static final Ip4Address BGP_SESSION_BGP_ID2 = Ip4Address.valueOf((String)"10.0.0.2");
    private static final Ip4Address BGP_SESSION_IP_ADDRESS2 = Ip4Address.valueOf((String)"20.0.0.1");
    private BgpSession bgpSession3;
    private static final Ip4Address BGP_SESSION_BGP_ID3 = Ip4Address.valueOf((String)"10.0.0.1");
    private static final Ip4Address BGP_SESSION_IP_ADDRESS3 = Ip4Address.valueOf((String)"20.0.0.2");
    private final BgpSessionInfo localInfo = new BgpSessionInfo();
    private final BgpSessionInfo remoteInfo = new BgpSessionInfo();
    private final BgpSessionInfo localInfo2 = new BgpSessionInfo();
    private final BgpSessionInfo remoteInfo2 = new BgpSessionInfo();
    private final BgpSessionInfo localInfo3 = new BgpSessionInfo();
    private final BgpSessionInfo remoteInfo3 = new BgpSessionInfo();

    @Before
    public void setUp() throws Exception {
        this.bgpSession = (BgpSession)EasyMock.createMock(BgpSession.class);
        this.bgpSession2 = (BgpSession)EasyMock.createMock(BgpSession.class);
        this.bgpSession3 = (BgpSession)EasyMock.createMock(BgpSession.class);
        this.remoteInfo.setIp4Address(BGP_SESSION_IP_ADDRESS);
        this.remoteInfo2.setIp4Address(BGP_SESSION_IP_ADDRESS2);
        this.remoteInfo3.setIp4Address(BGP_SESSION_IP_ADDRESS3);
        this.remoteInfo.setBgpId(BGP_SESSION_BGP_ID);
        this.remoteInfo2.setBgpId(BGP_SESSION_BGP_ID2);
        this.remoteInfo3.setBgpId(BGP_SESSION_BGP_ID3);
        EasyMock.expect((Object)this.bgpSession.localInfo()).andReturn((Object)this.localInfo).anyTimes();
        EasyMock.expect((Object)this.bgpSession.remoteInfo()).andReturn((Object)this.remoteInfo).anyTimes();
        EasyMock.expect((Object)this.bgpSession2.localInfo()).andReturn((Object)this.localInfo2).anyTimes();
        EasyMock.expect((Object)this.bgpSession2.remoteInfo()).andReturn((Object)this.remoteInfo2).anyTimes();
        EasyMock.expect((Object)this.bgpSession3.localInfo()).andReturn((Object)this.localInfo3).anyTimes();
        EasyMock.expect((Object)this.bgpSession3.remoteInfo()).andReturn((Object)this.remoteInfo3).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.bgpSession});
        EasyMock.replay((Object[])new Object[]{this.bgpSession2});
        EasyMock.replay((Object[])new Object[]{this.bgpSession3});
    }

    private BgpRouteEntry generateBgpRouteEntry() {
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 2;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(1L);
        segmentAsNumbers1.add(2L);
        segmentAsNumbers1.add(3L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        byte pathSegmentType2 = 1;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(4L);
        segmentAsNumbers2.add(5L);
        segmentAsNumbers2.add(6L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 100L;
        long multiExitDisc = 20L;
        BgpRouteEntry bgpRouteEntry = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry.setMultiExitDisc(multiExitDisc);
        return bgpRouteEntry;
    }

    @Test
    public void testConstructor() {
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        String expectedString = "BgpRouteEntry{prefix=1.2.3.0/24, nextHop=5.6.7.8, bgpId=10.0.0.1, origin=IGP, asPath=AsPath{pathSegments=[PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[1, 2, 3]}, PathSegment{type=AS_SET, segmentAsNumbers=[4, 5, 6]}]}, localPref=100, multiExitDisc=20}";
        Assert.assertThat((Object)bgpRouteEntry.toString(), (Matcher)Matchers.is((Object)expectedString));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullBgpSession() {
        BgpSession bgpSessionNull = null;
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList pathSegments = new ArrayList();
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 100L;
        new BgpRouteEntry(bgpSessionNull, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullAsPath() {
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        BgpRouteEntry.AsPath asPath = null;
        long localPref = 100L;
        new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
    }

    @Test
    public void testGetFields() {
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 2;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(1L);
        segmentAsNumbers1.add(2L);
        segmentAsNumbers1.add(3L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        byte pathSegmentType2 = 1;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(4L);
        segmentAsNumbers2.add(5L);
        segmentAsNumbers2.add(6L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 100L;
        long multiExitDisc = 20L;
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        Assert.assertThat((Object)bgpRouteEntry.prefix(), (Matcher)Matchers.is((Object)prefix));
        Assert.assertThat((Object)bgpRouteEntry.nextHop(), (Matcher)Matchers.is((Object)nextHop));
        Assert.assertThat((Object)bgpRouteEntry.getBgpSession(), (Matcher)Matchers.is((Object)this.bgpSession));
        Assert.assertThat((Object)bgpRouteEntry.getOrigin(), (Matcher)Matchers.is((Object)origin));
        Assert.assertThat((Object)bgpRouteEntry.getAsPath(), (Matcher)Matchers.is((Object)asPath));
        Assert.assertThat((Object)bgpRouteEntry.getLocalPref(), (Matcher)Matchers.is((Object)localPref));
        Assert.assertThat((Object)bgpRouteEntry.getMultiExitDisc(), (Matcher)Matchers.is((Object)multiExitDisc));
    }

    @Test
    public void testIsLocalRoute() {
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        Assert.assertThat((Object)bgpRouteEntry.isLocalRoute(), (Matcher)Matchers.is((Object)false));
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 1;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(1L);
        segmentAsNumbers1.add(2L);
        segmentAsNumbers1.add(3L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        byte pathSegmentType2 = 2;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(4L);
        segmentAsNumbers2.add(5L);
        segmentAsNumbers2.add(6L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 100L;
        long multiExitDisc = 20L;
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry.isLocalRoute(), (Matcher)Matchers.is((Object)true));
        pathSegments = new ArrayList();
        asPath = new BgpRouteEntry.AsPath(pathSegments);
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry.isLocalRoute(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetNeighborAs() {
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        Assert.assertThat((Object)bgpRouteEntry.getNeighborAs(), (Matcher)Matchers.is((Object)1L));
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList pathSegments = new ArrayList();
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 100L;
        long multiExitDisc = 20L;
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry.getNeighborAs(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testHasAsPathLoop() {
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        for (int i = 1; i <= 6; ++i) {
            Assert.assertThat((Object)bgpRouteEntry.hasAsPathLoop((long)i), (Matcher)Matchers.is((Object)true));
        }
        Assert.assertThat((Object)bgpRouteEntry.hasAsPathLoop(500L), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testBgpDecisionProcessComparison() {
        BgpRouteEntry bgpRouteEntry1 = this.generateBgpRouteEntry();
        BgpRouteEntry bgpRouteEntry2 = this.generateBgpRouteEntry();
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)true));
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 2;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(1L);
        segmentAsNumbers1.add(2L);
        segmentAsNumbers1.add(3L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        byte pathSegmentType2 = 1;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(4L);
        segmentAsNumbers2.add(5L);
        segmentAsNumbers2.add(6L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 50L;
        long multiExitDisc = 20L;
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)false));
        localPref = bgpRouteEntry1.getLocalPref();
        ArrayList<BgpRouteEntry.PathSegment> pathSegments2 = new ArrayList<BgpRouteEntry.PathSegment>();
        pathSegments2.add(pathSegment1);
        BgpRouteEntry.AsPath asPath2 = new BgpRouteEntry.AsPath(pathSegments2);
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath2, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)true));
        origin = 1;
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)false));
        origin = bgpRouteEntry1.getOrigin();
        multiExitDisc = 10L;
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)false));
        multiExitDisc = bgpRouteEntry1.getMultiExitDisc();
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession2, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)false));
        bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession3, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1.isBetterThan(bgpRouteEntry2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)bgpRouteEntry2.isBetterThan(bgpRouteEntry1), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEquality() {
        BgpRouteEntry bgpRouteEntry1 = this.generateBgpRouteEntry();
        BgpRouteEntry bgpRouteEntry2 = this.generateBgpRouteEntry();
        Assert.assertThat((Object)bgpRouteEntry1, (Matcher)Matchers.is((Object)bgpRouteEntry2));
    }

    @Test
    public void testNonEquality() {
        BgpRouteEntry bgpRouteEntry1 = this.generateBgpRouteEntry();
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Ip4Address nextHop = Ip4Address.valueOf((String)"5.6.7.8");
        byte origin = 0;
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 2;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(1L);
        segmentAsNumbers1.add(2L);
        segmentAsNumbers1.add(3L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        byte pathSegmentType2 = 1;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(4L);
        segmentAsNumbers2.add(5L);
        segmentAsNumbers2.add(6L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        long localPref = 500L;
        long multiExitDisc = 20L;
        BgpRouteEntry bgpRouteEntry2 = new BgpRouteEntry(this.bgpSession, (IpPrefix)prefix, (IpAddress)nextHop, origin, asPath, localPref);
        bgpRouteEntry2.setMultiExitDisc(multiExitDisc);
        Assert.assertThat((Object)bgpRouteEntry1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)bgpRouteEntry2)));
    }

    @Test
    public void testToString() {
        BgpRouteEntry bgpRouteEntry = this.generateBgpRouteEntry();
        String expectedString = "BgpRouteEntry{prefix=1.2.3.0/24, nextHop=5.6.7.8, bgpId=10.0.0.1, origin=IGP, asPath=AsPath{pathSegments=[PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[1, 2, 3]}, PathSegment{type=AS_SET, segmentAsNumbers=[4, 5, 6]}]}, localPref=100, multiExitDisc=20}";
        Assert.assertThat((Object)bgpRouteEntry.toString(), (Matcher)Matchers.is((Object)expectedString));
    }
}

