/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestUtils;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.BgpSessionInfo;
import org.onosproject.routing.bgp.BgpSessionManager;
import org.onosproject.routing.bgp.TestBgpPeerChannelHandler;
import org.onosproject.routing.bgp.TestBgpPeerFrameDecoder;
import org.osgi.service.component.ComponentContext;

public class BgpSessionManagerTest {
    private static final Ip4Address IP_LOOPBACK_ID = Ip4Address.valueOf((String)"127.0.0.1");
    private static final Ip4Address BGP_PEER1_ID = Ip4Address.valueOf((String)"10.0.0.1");
    private static final Ip4Address BGP_PEER2_ID = Ip4Address.valueOf((String)"10.0.0.2");
    private static final Ip4Address BGP_PEER3_ID = Ip4Address.valueOf((String)"10.0.0.3");
    private static final Ip4Address NEXT_HOP1_ROUTER = Ip4Address.valueOf((String)"10.20.30.41");
    private static final Ip4Address NEXT_HOP2_ROUTER = Ip4Address.valueOf((String)"10.20.30.42");
    private static final Ip4Address NEXT_HOP3_ROUTER = Ip4Address.valueOf((String)"10.20.30.43");
    private static final long DEFAULT_LOCAL_PREF = 10L;
    private static final long BETTER_LOCAL_PREF = 20L;
    private static final long DEFAULT_MULTI_EXIT_DISC = 20L;
    private static final long BETTER_MULTI_EXIT_DISC = 30L;
    BgpRouteEntry.AsPath asPathShort;
    BgpRouteEntry.AsPath asPathLong;
    private static final int MESSAGE_TIMEOUT_MS = 5000;
    private RouteAdminService routeService;
    private BgpSessionManager bgpSessionManager;
    private final Collection<TestBgpPeer> peers = new LinkedList<TestBgpPeer>();
    TestBgpPeer peer1;
    TestBgpPeer peer2;
    TestBgpPeer peer3;
    BgpSession bgpSession1;
    BgpSession bgpSession2;
    BgpSession bgpSession3;
    private InetSocketAddress connectToSocket;

    private static BgpRouteEntryAndPeerMatcher hasBgpRouteEntry(BgpRouteEntry bgpRouteEntry) {
        return new BgpRouteEntryAndPeerMatcher(bgpRouteEntry);
    }

    private void getDictionaryMock(ComponentContext componentContext) {
        Dictionary dictionary = (Dictionary)EasyMock.createMock(Dictionary.class);
        EasyMock.expect(dictionary.get("bgpPort")).andReturn((Object)"0");
        EasyMock.replay((Object[])new Object[]{dictionary});
        EasyMock.expect((Object)componentContext.getProperties()).andReturn((Object)dictionary);
    }

    @Before
    public void setUp() throws Exception {
        this.peer1 = new TestBgpPeer(BGP_PEER1_ID);
        this.peer2 = new TestBgpPeer(BGP_PEER2_ID);
        this.peer3 = new TestBgpPeer(BGP_PEER3_ID);
        this.peers.clear();
        this.peers.add(this.peer1);
        this.peers.add(this.peer2);
        this.peers.add(this.peer3);
        this.bgpSessionManager = new BgpSessionManager();
        this.routeService = (RouteAdminService)EasyMock.createNiceMock(RouteAdminService.class);
        EasyMock.replay((Object[])new Object[]{this.routeService});
        this.bgpSessionManager.routeService = this.routeService;
        ComponentContext componentContext = (ComponentContext)EasyMock.createMock(ComponentContext.class);
        this.getDictionaryMock(componentContext);
        EasyMock.replay((Object[])new Object[]{componentContext});
        this.bgpSessionManager.activate(componentContext);
        Channel serverChannel = (Channel)TestUtils.getField((Object)this.bgpSessionManager, (String)"serverChannel");
        SocketAddress socketAddress = serverChannel.getLocalAddress();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress connectToAddress = InetAddresses.forString((String)"127.0.0.1");
        this.connectToSocket = new InetSocketAddress(connectToAddress, inetSocketAddress.getPort());
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType1 = 2;
        ArrayList<Long> segmentAsNumbers1 = new ArrayList<Long>();
        segmentAsNumbers1.add(65010L);
        segmentAsNumbers1.add(65020L);
        segmentAsNumbers1.add(65030L);
        BgpRouteEntry.PathSegment pathSegment1 = new BgpRouteEntry.PathSegment(pathSegmentType1, segmentAsNumbers1);
        pathSegments.add(pathSegment1);
        this.asPathShort = new BgpRouteEntry.AsPath(new ArrayList(pathSegments));
        byte pathSegmentType2 = 1;
        ArrayList<Long> segmentAsNumbers2 = new ArrayList<Long>();
        segmentAsNumbers2.add(65041L);
        segmentAsNumbers2.add(65042L);
        segmentAsNumbers2.add(65043L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType2, segmentAsNumbers2);
        pathSegments.add(pathSegment2);
        this.asPathLong = new BgpRouteEntry.AsPath(pathSegments);
    }

    @After
    public void tearDown() throws Exception {
        this.bgpSessionManager.stop();
        this.bgpSessionManager = null;
    }

    private Collection<BgpRouteEntry> waitForBgpRibIn(BgpSession bgpSession, long expectedRoutes) throws InterruptedException {
        Collection bgpRibIn = bgpSession.getBgpRibIn4();
        int maxChecks = 500;
        for (int i = 0; i < 500 && (long)bgpRibIn.size() != expectedRoutes; ++i) {
            Thread.sleep(10L);
            bgpRibIn = bgpSession.getBgpRibIn4();
        }
        return bgpRibIn;
    }

    private Collection<BgpRouteEntry> waitForBgpRoutes(long expectedRoutes) throws InterruptedException {
        Collection bgpRoutes = this.bgpSessionManager.getBgpRoutes4();
        int maxChecks = 500;
        for (int i = 0; i < 500 && (long)bgpRoutes.size() != expectedRoutes; ++i) {
            Thread.sleep(10L);
            bgpRoutes = this.bgpSessionManager.getBgpRoutes4();
        }
        return bgpRoutes;
    }

    private BgpRouteEntry waitForBgpRoute(BgpRouteEntry expectedRoute) throws InterruptedException {
        Collection bgpRoutes = this.bgpSessionManager.getBgpRoutes4();
        int maxChecks = 500;
        for (int i = 0; i < 500; ++i) {
            for (BgpRouteEntry bgpRouteEntry : bgpRoutes) {
                if (!bgpRouteEntry.equals((Object)expectedRoute) || bgpRouteEntry.getBgpSession() != expectedRoute.getBgpSession()) continue;
                return bgpRouteEntry;
            }
            Thread.sleep(10L);
            bgpRoutes = this.bgpSessionManager.getBgpRoutes4();
        }
        return null;
    }

    @Test
    public void testExchangedBgpOpenMessages() throws InterruptedException, TestUtils.TestUtilsException {
        this.peer1.connect(this.connectToSocket);
        this.peer2.connect(this.connectToSocket);
        this.peer3.connect(this.connectToSocket);
        for (TestBgpPeer peer : this.peers) {
            Assert.assertThat((Object)((TestBgpPeer)peer).peerFrameDecoder.remoteInfo.bgpVersion(), (Matcher)Matchers.is((Object)4));
            Assert.assertThat((Object)((TestBgpPeer)peer).peerFrameDecoder.remoteInfo.bgpId(), (Matcher)Matchers.is((Object)IP_LOOPBACK_ID));
            Assert.assertThat((Object)((TestBgpPeer)peer).peerFrameDecoder.remoteInfo.asNumber(), (Matcher)Matchers.is((Object)65001L));
        }
        Assert.assertThat((Object)this.bgpSessionManager.getMyBgpId(), (Matcher)Matchers.is((Object)IP_LOOPBACK_ID));
        Assert.assertThat((Object)this.bgpSessionManager.getBgpSessions(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.bgpSession1, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.bgpSession2, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.bgpSession3, (Matcher)Matchers.notNullValue());
        for (BgpSession bgpSession : this.bgpSessionManager.getBgpSessions()) {
            long sessionAs = bgpSession.localInfo().asNumber();
            Assert.assertThat((Object)sessionAs, (Matcher)Matchers.is((Object)65001L));
        }
    }

    @Test
    public void testExchangedBgpOpenCapabilityMessages() throws InterruptedException, TestUtils.TestUtilsException {
        for (TestBgpPeer peer : this.peers) {
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setIpv4Unicast();
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setIpv4Multicast();
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setIpv6Unicast();
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setIpv6Multicast();
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setAs4OctetCapability();
            ((TestBgpPeer)peer).peerChannelHandler.localInfo.setAs4Number(305419896L);
        }
        this.peer1.connect(this.connectToSocket);
        this.peer2.connect(this.connectToSocket);
        this.peer3.connect(this.connectToSocket);
        for (TestBgpPeer peer : this.peers) {
            Assert.assertThat((Object)((TestBgpPeer)peer).peerFrameDecoder.remoteInfo.bgpVersion(), (Matcher)Matchers.is((Object)4));
            Assert.assertThat((Object)((TestBgpPeer)peer).peerFrameDecoder.remoteInfo.bgpId(), (Matcher)Matchers.is((Object)IP_LOOPBACK_ID));
        }
        Assert.assertThat((Object)this.bgpSessionManager.getMyBgpId(), (Matcher)Matchers.is((Object)IP_LOOPBACK_ID));
        Assert.assertThat((Object)this.bgpSessionManager.getBgpSessions(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)this.bgpSession1, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.bgpSession2, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.bgpSession3, (Matcher)Matchers.notNullValue());
        for (BgpSession bgpSession : this.bgpSessionManager.getBgpSessions()) {
            BgpSessionInfo localInfo = bgpSession.localInfo();
            Assert.assertThat((Object)localInfo.ipv4Unicast(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)localInfo.ipv4Multicast(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)localInfo.ipv6Unicast(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)localInfo.ipv6Multicast(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)localInfo.as4OctetCapability(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)localInfo.asNumber(), (Matcher)Matchers.is((Object)305419896L));
            Assert.assertThat((Object)localInfo.as4Number(), (Matcher)Matchers.is((Object)305419896L));
        }
    }

    @Test
    public void testProcessedBgpUpdateMessages() throws InterruptedException {
        this.peer1.connect(this.connectToSocket);
        this.peer2.connect(this.connectToSocket);
        this.peer3.connect(this.connectToSocket);
        LinkedList<Object> addedRoutes = new LinkedList<Ip4Prefix>();
        LinkedList<Object> withdrawnRoutes = new LinkedList<Ip4Prefix>();
        addedRoutes.add(Ip4Prefix.valueOf((String)"0.0.0.0/0"));
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        addedRoutes.add(Ip4Prefix.valueOf((String)"30.0.0.0/16"));
        addedRoutes.add(Ip4Prefix.valueOf((String)"40.0.0.0/24"));
        addedRoutes.add(Ip4Prefix.valueOf((String)"50.0.0.0/32"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"60.0.0.0/8"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"70.0.0.0/16"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"80.0.0.0/24"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"90.0.0.0/32"));
        ChannelBuffer message = this.peer1.peerChannelHandler.prepareBgpUpdate(NEXT_HOP1_ROUTER, 10L, 20L, this.asPathLong, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer1).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        Collection<BgpRouteEntry> bgpRibIn1 = this.waitForBgpRibIn(this.bgpSession1, 5L);
        Assert.assertThat(bgpRibIn1, (Matcher)Matchers.hasSize((int)5));
        Collection<BgpRouteEntry> bgpRoutes = this.waitForBgpRoutes(5L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)5));
        BgpRouteEntry bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/0"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"30.0.0.0/16"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"40.0.0.0/24"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"50.0.0.0/32"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"0.0.0.0/0"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"50.0.0.0/32"));
        message = this.peer1.peerChannelHandler.prepareBgpUpdate(NEXT_HOP1_ROUTER, 10L, 20L, this.asPathLong, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer1).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        bgpRibIn1 = this.waitForBgpRibIn(this.bgpSession1, 3L);
        Assert.assertThat(bgpRibIn1, (Matcher)Matchers.hasSize((int)3));
        bgpRoutes = this.waitForBgpRoutes(3L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)3));
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"30.0.0.0/16"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"40.0.0.0/24"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathLong, 10L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        this.peer1.peerChannelHandler.closeChannel();
        this.peer2.peerChannelHandler.closeChannel();
        this.peer3.peerChannelHandler.closeChannel();
        bgpRoutes = this.waitForBgpRoutes(0L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testBgpRoutePreference() throws InterruptedException {
        LinkedList<Object> addedRoutes = new LinkedList<Ip4Prefix>();
        LinkedList<Object> withdrawnRoutes = new LinkedList<Ip4Prefix>();
        this.peer1.connect(this.connectToSocket);
        this.peer2.connect(this.connectToSocket);
        this.peer3.connect(this.connectToSocket);
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        addedRoutes.add(Ip4Prefix.valueOf((String)"30.0.0.0/16"));
        ChannelBuffer message = this.peer1.peerChannelHandler.prepareBgpUpdate(NEXT_HOP1_ROUTER, 10L, 20L, this.asPathLong, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer1).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        Collection<BgpRouteEntry> bgpRoutes = this.waitForBgpRoutes(2L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)2));
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        message = this.peer2.peerChannelHandler.prepareBgpUpdate(NEXT_HOP2_ROUTER, 20L, 20L, this.asPathLong, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer2).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        Collection<BgpRouteEntry> bgpRibIn2 = this.waitForBgpRibIn(this.bgpSession2, 1L);
        Assert.assertThat(bgpRibIn2, (Matcher)Matchers.hasSize((int)1));
        bgpRoutes = this.waitForBgpRoutes(2L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)2));
        BgpRouteEntry bgpRouteEntry = new BgpRouteEntry(this.bgpSession2, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP2_ROUTER, 0, this.asPathLong, 20L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn2, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        message = this.peer3.peerChannelHandler.prepareBgpUpdate(NEXT_HOP3_ROUTER, 20L, 20L, this.asPathShort, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer3).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        Collection<BgpRouteEntry> bgpRibIn3 = this.waitForBgpRibIn(this.bgpSession3, 1L);
        Assert.assertThat(bgpRibIn3, (Matcher)Matchers.hasSize((int)1));
        bgpRoutes = this.waitForBgpRoutes(2L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)2));
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession3, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP3_ROUTER, 0, this.asPathShort, 20L);
        bgpRouteEntry.setMultiExitDisc(20L);
        Assert.assertThat(bgpRibIn3, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        message = this.peer2.peerChannelHandler.prepareBgpUpdate(NEXT_HOP2_ROUTER, 20L, 30L, this.asPathShort, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer2).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        bgpRibIn2 = this.waitForBgpRibIn(this.bgpSession2, 0L);
        Assert.assertThat(bgpRibIn2, (Matcher)Matchers.hasSize((int)0));
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        message = this.peer2.peerChannelHandler.prepareBgpUpdate(NEXT_HOP2_ROUTER, 20L, 30L, this.asPathShort, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer2).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        bgpRibIn2 = this.waitForBgpRibIn(this.bgpSession2, 1L);
        Assert.assertThat(bgpRibIn2, (Matcher)Matchers.hasSize((int)1));
        bgpRoutes = this.waitForBgpRoutes(2L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)2));
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession2, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP2_ROUTER, 0, this.asPathShort, 20L);
        bgpRouteEntry.setMultiExitDisc(30L);
        Assert.assertThat(bgpRibIn2, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        addedRoutes = new LinkedList();
        withdrawnRoutes = new LinkedList();
        addedRoutes.add(Ip4Prefix.valueOf((String)"20.0.0.0/8"));
        withdrawnRoutes.add(Ip4Prefix.valueOf((String)"30.0.0.0/16"));
        message = this.peer1.peerChannelHandler.prepareBgpUpdate(NEXT_HOP1_ROUTER, 20L, 30L, this.asPathShort, addedRoutes, withdrawnRoutes);
        ((TestBgpPeer)this.peer1).peerChannelHandler.savedCtx.getChannel().write((Object)message);
        Collection<BgpRouteEntry> bgpRibIn1 = this.waitForBgpRibIn(this.bgpSession1, 1L);
        Assert.assertThat(bgpRibIn1, (Matcher)Matchers.hasSize((int)1));
        bgpRoutes = this.waitForBgpRoutes(1L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)1));
        bgpRouteEntry = new BgpRouteEntry(this.bgpSession1, (IpPrefix)Ip4Prefix.valueOf((String)"20.0.0.0/8"), (IpAddress)NEXT_HOP1_ROUTER, 0, this.asPathShort, 20L);
        bgpRouteEntry.setMultiExitDisc(30L);
        Assert.assertThat(bgpRibIn1, (Matcher)BgpSessionManagerTest.hasBgpRouteEntry(bgpRouteEntry));
        Assert.assertThat((Object)this.waitForBgpRoute(bgpRouteEntry), (Matcher)Matchers.notNullValue());
        this.peer1.peerChannelHandler.closeChannel();
        this.peer2.peerChannelHandler.closeChannel();
        this.peer3.peerChannelHandler.closeChannel();
        bgpRoutes = this.waitForBgpRoutes(0L);
        Assert.assertThat(bgpRoutes, (Matcher)Matchers.hasSize((int)0));
    }

    private static final class BgpRouteEntryAndPeerMatcher
    extends TypeSafeMatcher<Collection<BgpRouteEntry>> {
        private final BgpRouteEntry bgpRouteEntry;

        private BgpRouteEntryAndPeerMatcher(BgpRouteEntry bgpRouteEntry) {
            this.bgpRouteEntry = bgpRouteEntry;
        }

        public boolean matchesSafely(Collection<BgpRouteEntry> entries) {
            for (BgpRouteEntry entry : entries) {
                if (!this.bgpRouteEntry.equals((Object)entry) || this.bgpRouteEntry.getBgpSession() != entry.getBgpSession()) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("BGP route entry lookup for entry \"").appendText(this.bgpRouteEntry.toString()).appendText("\"");
        }
    }

    private final class TestBgpPeer {
        private final Ip4Address peerId;
        private ClientBootstrap peerBootstrap;
        private TestBgpPeerChannelHandler peerChannelHandler;
        private TestBgpPeerFrameDecoder peerFrameDecoder = new TestBgpPeerFrameDecoder();

        private TestBgpPeer(Ip4Address peerId) {
            this.peerId = peerId;
            this.peerChannelHandler = new TestBgpPeerChannelHandler(peerId);
        }

        private void connect(InetSocketAddress connectToSocket) throws InterruptedException {
            NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            ChannelPipelineFactory pipelineFactory = () -> {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("TestBgpPeerFrameDecoder", (ChannelHandler)this.peerFrameDecoder);
                pipeline.addLast("TestBgpPeerChannelHandler", (ChannelHandler)this.peerChannelHandler);
                return pipeline;
            };
            this.peerBootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
            this.peerBootstrap.setOption("child.keepAlive", (Object)true);
            this.peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
            this.peerBootstrap.setPipelineFactory(pipelineFactory);
            this.peerBootstrap.connect((SocketAddress)connectToSocket);
            boolean result = this.peerFrameDecoder.receivedOpenMessageLatch.await(5000L, TimeUnit.MILLISECONDS);
            Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
            result = this.peerFrameDecoder.receivedKeepaliveMessageLatch.await(5000L, TimeUnit.MILLISECONDS);
            Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
            for (BgpSession bgpSession : BgpSessionManagerTest.this.bgpSessionManager.getBgpSessions()) {
                if (bgpSession.remoteInfo().bgpId().equals((Object)BGP_PEER1_ID)) {
                    BgpSessionManagerTest.this.bgpSession1 = bgpSession;
                }
                if (bgpSession.remoteInfo().bgpId().equals((Object)BGP_PEER2_ID)) {
                    BgpSessionManagerTest.this.bgpSession2 = bgpSession;
                }
                if (!bgpSession.remoteInfo().bgpId().equals((Object)BGP_PEER3_ID)) continue;
                BgpSessionManagerTest.this.bgpSession3 = bgpSession;
            }
        }
    }
}

