/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.Collection;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onosproject.routing.bgp.BgpKeepalive;
import org.onosproject.routing.bgp.BgpMessage;
import org.onosproject.routing.bgp.BgpOpen;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpSessionInfo;

class TestBgpPeerChannelHandler
extends SimpleChannelHandler {
    static final long PEER_AS = 65001L;
    static final long PEER_AS4 = 305419896L;
    static final int PEER_HOLDTIME = 120;
    final BgpSessionInfo localInfo = new BgpSessionInfo();
    ChannelHandlerContext savedCtx;

    TestBgpPeerChannelHandler(Ip4Address bgpId) {
        this.localInfo.setBgpVersion(4);
        this.localInfo.setBgpId(bgpId);
        this.localInfo.setAsNumber(65001L);
        this.localInfo.setHoldtime(120L);
    }

    void closeChannel() {
        this.savedCtx.getChannel().close();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
        this.savedCtx = ctx;
        ChannelBuffer message = BgpOpen.prepareBgpOpen((BgpSessionInfo)this.localInfo);
        ctx.getChannel().write((Object)message);
        message = BgpKeepalive.prepareBgpKeepalive();
        ctx.getChannel().write((Object)message);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
    }

    ChannelBuffer prepareBgpUpdate(Ip4Address nextHopRouter, long localPref, long multiExitDisc, BgpRouteEntry.AsPath asPath, Collection<Ip4Prefix> addedRoutes, Collection<Ip4Prefix> withdrawnRoutes) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        ChannelBuffer pathAttributes = ChannelBuffers.buffer((int)4096);
        ChannelBuffer encodedPrefixes = this.encodePackedPrefixes(withdrawnRoutes);
        message.writeShort(encodedPrefixes.readableBytes());
        message.writeBytes(encodedPrefixes);
        int attrFlags = 64;
        pathAttributes.writeByte(attrFlags);
        pathAttributes.writeByte(1);
        pathAttributes.writeByte(1);
        pathAttributes.writeByte(0);
        attrFlags = 64;
        pathAttributes.writeByte(attrFlags);
        pathAttributes.writeByte(2);
        ChannelBuffer encodedAsPath = this.encodeAsPath(asPath);
        pathAttributes.writeByte(encodedAsPath.readableBytes());
        pathAttributes.writeBytes(encodedAsPath);
        attrFlags = 64;
        pathAttributes.writeByte(attrFlags);
        pathAttributes.writeByte(3);
        pathAttributes.writeByte(4);
        pathAttributes.writeInt(nextHopRouter.toInt());
        attrFlags = 64;
        pathAttributes.writeByte(attrFlags);
        pathAttributes.writeByte(5);
        pathAttributes.writeByte(4);
        pathAttributes.writeInt((int)localPref);
        attrFlags = 128;
        pathAttributes.writeByte(attrFlags);
        pathAttributes.writeByte(4);
        pathAttributes.writeByte(4);
        pathAttributes.writeInt((int)multiExitDisc);
        encodedPrefixes = this.encodePackedPrefixes(addedRoutes);
        message.writeShort(pathAttributes.readableBytes());
        message.writeBytes(pathAttributes);
        message.writeBytes(encodedPrefixes);
        return BgpMessage.prepareBgpMessage((int)2, (ChannelBuffer)message);
    }

    private ChannelBuffer encodePackedPrefixes(Collection<Ip4Prefix> prefixes) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        for (Ip4Prefix prefix : prefixes) {
            int prefixBitlen = prefix.prefixLength();
            int prefixBytelen = (prefixBitlen + 7) / 8;
            message.writeByte(prefixBitlen);
            Ip4Address address = prefix.address();
            long value = (long)address.toInt() & 0xFFFFFFFFL;
            for (int i = 0; i < 4 && prefixBytelen-- != 0; ++i) {
                long nextByte = value >> (4 - i - 1) * 8 & 0xFFL;
                message.writeByte((int)nextByte);
            }
        }
        return message;
    }

    private ChannelBuffer encodeAsPath(BgpRouteEntry.AsPath asPath) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        for (BgpRouteEntry.PathSegment pathSegment : asPath.getPathSegments()) {
            message.writeByte((int)pathSegment.getType());
            message.writeByte(pathSegment.getSegmentAsNumbers().size());
            for (Long asNumber : pathSegment.getSegmentAsNumbers()) {
                message.writeShort(asNumber.intValue());
            }
        }
        return message;
    }
}

