/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IpAddress;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RouteAttributeDecoder;

public final class RouteAttributeGateway
extends RouteAttribute {
    public static final int VALUE_LENGTH = 4;
    private final IpAddress gateway;

    private RouteAttributeGateway(int length, int type, IpAddress gateway) {
        super(length, type);
        this.gateway = gateway;
    }

    public IpAddress gateway() {
        return this.gateway;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", this.type()).add("length", this.length()).add("gateway", (Object)this.gateway).toString();
    }

    public static RouteAttributeDecoder<RouteAttributeGateway> decoder() {
        return (length, type, value) -> {
            IpAddress gateway;
            if (value.length == 4) {
                gateway = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
            } else if (value.length == 16) {
                gateway = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
            } else {
                throw new DeserializationException("Invalid address length");
            }
            return new RouteAttributeGateway(length, type, gateway);
        };
    }
}

