/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RouteAttributeDecoder;

public final class RouteAttributeOif
extends RouteAttribute {
    private static final int VALUE_LENGTH = 4;
    private final long outputInterface;

    private RouteAttributeOif(int length, int type, long outputInterface) {
        super(length, type);
        this.outputInterface = outputInterface;
    }

    public long outputInterface() {
        return this.outputInterface;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", this.type()).add("length", this.length()).add("outputInterface", this.outputInterface).toString();
    }

    public static RouteAttributeDecoder<RouteAttributeOif> decoder() {
        return (length, type, value) -> {
            if (value.length != 4) {
                throw new DeserializationException("Wrong value length");
            }
            long outputInterface = Integer.reverseBytes(ByteBuffer.wrap(value).getInt());
            return new RouteAttributeOif(length, type, outputInterface);
        };
    }
}

