/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.routing.FibEntry;
import org.onosproject.routing.FibListener;
import org.onosproject.routing.FibUpdate;
import org.onosproject.routing.RouteEntry;
import org.onosproject.routing.RoutingService;

@Service
@Component(immediate=true, enabled=false)
public class Router
implements RoutingService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteService routeService;

    public void start() {
    }

    public void addFibListener(FibListener fibListener) {
        this.routeService.addListener((EventListener)new InternalRouteListener(fibListener));
    }

    public void stop() {
    }

    public Collection<RouteEntry> getRoutes4() {
        return ((Collection)this.routeService.getAllRoutes().get(new RouteTableId("ipv4"))).stream().map(route -> new RouteEntry(route.prefix(), route.nextHop())).collect(Collectors.toList());
    }

    public Collection<RouteEntry> getRoutes6() {
        return ((Collection)this.routeService.getAllRoutes().get(new RouteTableId("ipv6"))).stream().map(route -> new RouteEntry(route.prefix(), route.nextHop())).collect(Collectors.toList());
    }

    public RouteEntry getLongestMatchableRouteEntry(IpAddress ipAddress) {
        Route route = this.routeService.longestPrefixMatch(ipAddress);
        if (route != null) {
            return new RouteEntry(route.prefix(), route.nextHop());
        }
        return null;
    }

    protected void bindRouteService(RouteService routeService) {
        this.routeService = routeService;
    }

    protected void unbindRouteService(RouteService routeService) {
        if (this.routeService == routeService) {
            this.routeService = null;
        }
    }

    private class InternalRouteListener
    implements RouteListener {
        private final FibListener fibListener;

        public InternalRouteListener(FibListener fibListener) {
            this.fibListener = fibListener;
        }

        public void event(RouteEvent event) {
            ResolvedRoute route = (ResolvedRoute)event.subject();
            FibEntry entry = new FibEntry(route.prefix(), route.nextHop(), route.nextHopMac());
            switch ((RouteEvent.Type)event.type()) {
                case ROUTE_ADDED: 
                case ROUTE_UPDATED: {
                    this.fibListener.update(Collections.singleton(new FibUpdate(FibUpdate.Type.UPDATE, entry)), Collections.emptyList());
                    break;
                }
                case ROUTE_REMOVED: {
                    this.fibListener.update(Collections.emptyList(), Collections.singleton(new FibUpdate(FibUpdate.Type.DELETE, entry)));
                    break;
                }
            }
        }
    }
}

