/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.concurrent.CountDownLatch;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onlab.packet.Ip4Address;
import org.onosproject.routing.bgp.BgpSessionInfo;

class TestBgpPeerFrameDecoder
extends FrameDecoder {
    final BgpSessionInfo remoteInfo = new BgpSessionInfo();
    final CountDownLatch receivedOpenMessageLatch = new CountDownLatch(1);
    final CountDownLatch receivedKeepaliveMessageLatch = new CountDownLatch(1);

    TestBgpPeerFrameDecoder() {
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) throws Exception {
        if (buf.readableBytes() < 19) {
            return null;
        }
        buf.markReaderIndex();
        byte[] marker = new byte[16];
        buf.readBytes(marker);
        for (int i = 0; i < marker.length; ++i) {
            if (marker[i] == -1) continue;
            ctx.getChannel().close();
            return null;
        }
        int length = buf.readUnsignedShort();
        if (length < 19 || length > 4096) {
            ctx.getChannel().close();
            return null;
        }
        int remainingMessageLen = length - 16 - 2;
        if (buf.readableBytes() < remainingMessageLen) {
            buf.resetReaderIndex();
            return null;
        }
        short type = buf.readUnsignedByte();
        ChannelBuffer message = buf.readBytes(--remainingMessageLen);
        switch (type) {
            case 1: {
                this.processBgpOpen(ctx, message);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.processBgpKeepalive(ctx, message);
                break;
            }
            default: {
                ctx.getChannel().close();
                return null;
            }
        }
        return null;
    }

    private void processBgpOpen(ChannelHandlerContext ctx, ChannelBuffer message) {
        int minLength = 10;
        if (message.readableBytes() < minLength) {
            ctx.getChannel().close();
            return;
        }
        this.remoteInfo.setBgpVersion((int)message.readUnsignedByte());
        this.remoteInfo.setAsNumber((long)message.readUnsignedShort());
        this.remoteInfo.setHoldtime((long)message.readUnsignedShort());
        this.remoteInfo.setBgpId(Ip4Address.valueOf((int)((int)message.readUnsignedInt())));
        short optParamLen = message.readUnsignedByte();
        if (message.readableBytes() < optParamLen) {
            ctx.getChannel().close();
            return;
        }
        message.readBytes((int)optParamLen);
        this.receivedOpenMessageLatch.countDown();
    }

    private void processBgpKeepalive(ChannelHandlerContext ctx, ChannelBuffer message) {
        if (message.readableBytes() + 19 != 19) {
            ctx.getChannel().close();
            return;
        }
        this.receivedKeepaliveMessageLatch.countDown();
    }
}

