/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.onosproject.routing.bgp.BgpMessage;
import org.onosproject.routing.bgp.BgpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BgpNotification {
    private static final Logger log = LoggerFactory.getLogger(BgpNotification.class);

    private BgpNotification() {
    }

    static void processBgpNotification(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message) {
        int minLength = 2;
        if (message.readableBytes() < minLength) {
            log.debug("BGP RX NOTIFICATION Error from {}: Message length {} too short. Must be at least {}", new Object[]{bgpSession.remoteInfo().address(), message.readableBytes(), minLength});
            return;
        }
        short errorCode = message.readUnsignedByte();
        short errorSubcode = message.readUnsignedByte();
        int dataLength = message.readableBytes();
        log.debug("BGP RX NOTIFICATION message from {}: Error Code {} Error Subcode {} Data Length {}", new Object[]{bgpSession.remoteInfo().address(), (int)errorCode, (int)errorSubcode, dataLength});
        bgpSession.restartSessionTimeoutTimer(ctx);
    }

    static ChannelBuffer prepareBgpNotification(int errorCode, int errorSubcode, ChannelBuffer data) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        message.writeByte(errorCode);
        message.writeByte(errorSubcode);
        if (data != null) {
            message.writeBytes(data);
        }
        return BgpMessage.prepareBgpMessage(3, message);
    }

    static ChannelBuffer prepareBgpNotificationBadMessageLength(int length) {
        int errorCode = 1;
        int errorSubcode = 2;
        ChannelBuffer data = ChannelBuffers.buffer((int)2);
        data.writeShort(length);
        return BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
    }
}

