/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
public class DirectHostManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    private static final boolean DEFAULT_ENABLED = false;
    @Property(name="enabled", boolValue={false}, label="Enable reactive directly-connected host processing")
    private volatile boolean enabled = false;
    private static final String APP_NAME = "org.onosproject.directhost";
    private static final long MAX_QUEUED_PACKETS = 10000L;
    private static final long MAX_QUEUE_DURATION = 2L;
    private ApplicationId appId;
    private InternalPacketProcessor packetProcessor = new InternalPacketProcessor();
    private InternalHostListener hostListener = new InternalHostListener();
    private Cache<IpAddress, Queue<IPv4>> ipPacketCache = CacheBuilder.newBuilder().weigher((key, value) -> value.size()).maximumWeight(10000L).expireAfterAccess(2L, TimeUnit.SECONDS).build();

    @Activate
    public void activate(ComponentContext context) {
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.appId = this.coreService.registerApplication(APP_NAME);
        if (this.enabled) {
            this.enable();
        }
    }

    @Modified
    private void modified(ComponentContext context) {
        Boolean boolEnabled = Tools.isPropertyEnabled((Dictionary)context.getProperties(), (String)"enabled");
        if (boolEnabled != null) {
            if (this.enabled && !boolEnabled.booleanValue()) {
                this.enabled = false;
                this.disable();
            } else if (!this.enabled && boolEnabled.booleanValue()) {
                this.enabled = true;
                this.enable();
            }
        }
    }

    private void enable() {
        this.hostService.addListener((EventListener)this.hostListener);
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)3));
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).build();
        this.packetService.requestPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
    }

    private void disable() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.hostService.removeListener((EventListener)this.hostListener);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).build();
        this.packetService.cancelPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
    }

    @Deactivate
    public void deactivate() {
        this.disable();
        this.componentConfigService.unregisterProperties(this.getClass(), false);
    }

    private void handle(Ethernet eth) {
        Preconditions.checkNotNull((Object)eth);
        if (eth.getEtherType() != EthType.EtherType.IPV4.ethType().toShort()) {
            return;
        }
        IPv4 ipv4 = (IPv4)eth.getPayload().clone();
        Ip4Address dstIp = Ip4Address.valueOf((int)ipv4.getDestinationAddress());
        Interface egressInterface = this.interfaceService.getMatchingInterface((IpAddress)dstIp);
        if (egressInterface == null) {
            this.log.info("No egress interface found for {}", (Object)dstIp);
            return;
        }
        Optional<Host> host = this.hostService.getHostsByIp((IpAddress)dstIp).stream().filter(h -> h.location().equals((Object)egressInterface.connectPoint())).filter(h -> h.vlan().equals((Object)egressInterface.vlan())).findAny();
        if (host.isPresent()) {
            this.transformAndSend(ipv4, egressInterface, host.get().mac());
        } else {
            this.hostService.startMonitoringIp((IpAddress)dstIp);
            this.ipPacketCache.asMap().compute(dstIp, (ip, queue) -> {
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<IPv4>();
                }
                queue.add(ipv4);
                return queue;
            });
        }
    }

    private void transformAndSend(IPv4 ipv4, Interface egressInterface, MacAddress macAddress) {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(macAddress);
        eth.setSourceMACAddress(egressInterface.mac());
        eth.setEtherType(EthType.EtherType.IPV4.ethType().toShort());
        eth.setPayload((IPacket)ipv4);
        if (!egressInterface.vlan().equals((Object)VlanId.NONE)) {
            eth.setVlanID(egressInterface.vlan().toShort());
        }
        ipv4.setTtl((byte)(ipv4.getTtl() - 1));
        ipv4.setChecksum((short)0);
        this.send(eth, egressInterface.connectPoint());
    }

    private void send(Ethernet eth, ConnectPoint cp) {
        DefaultOutboundPacket packet = new DefaultOutboundPacket(cp.deviceId(), DefaultTrafficTreatment.builder().setOutput(cp.port()).build(), ByteBuffer.wrap(eth.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    private void sendQueued(IpAddress ipAddress, MacAddress macAddress) {
        this.log.debug("Sending queued packets for {} ({})", (Object)ipAddress, (Object)macAddress);
        this.ipPacketCache.asMap().computeIfPresent(ipAddress, (ip, packets) -> {
            packets.forEach(ipv4 -> {
                Interface egressInterface = this.interfaceService.getMatchingInterface(ipAddress);
                if (egressInterface == null) {
                    this.log.info("No egress interface found for {}", (Object)ipAddress);
                    return;
                }
                this.transformAndSend((IPv4)ipv4, egressInterface, macAddress);
            });
            return null;
        });
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: {
                    ((Host)event.subject()).ipAddresses().forEach(ip -> DirectHostManager.this.sendQueued(ip, ((Host)event.subject()).mac()));
                    break;
                }
            }
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            if (DirectHostManager.this.interfaceService.getInterfacesByPort(context.inPacket().receivedFrom()).isEmpty()) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            if (eth == null) {
                return;
            }
            DirectHostManager.this.handle(eth);
            context.block();
        }
    }
}

