/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.TestApplicationId;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.LeadershipServiceAdapter;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.routing.impl.IntentSynchronizer;

public class IntentSynchronizerTest
extends AbstractIntentTest {
    private IntentService intentService;
    private static final ConnectPoint SW1_ETH1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000001"), PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW2_ETH1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000002"), PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW3_ETH1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000003"), PortNumber.portNumber((long)1L));
    private static final ConnectPoint SW4_ETH1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000004"), PortNumber.portNumber((long)1L));
    private IntentSynchronizer intentSynchronizer;
    private final Set<ConnectPoint> connectPoints = new HashSet<ConnectPoint>();
    private static final ApplicationId APPID = TestApplicationId.create((String)"intent-sync-test");
    private static final ControllerNode LOCAL_NODE = new DefaultControllerNode(new NodeId("foo"), IpAddress.valueOf((String)"127.0.0.1"));

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpConnectPoints();
        this.intentService = (IntentService)EasyMock.createMock(IntentService.class);
        this.intentSynchronizer = new TestIntentSynchronizer();
        this.intentSynchronizer.coreService = new TestCoreService();
        this.intentSynchronizer.clusterService = new TestClusterService();
        this.intentSynchronizer.leadershipService = new LeadershipServiceAdapter();
        this.intentSynchronizer.intentService = this.intentService;
        this.intentSynchronizer.activate();
    }

    private void setUpConnectPoints() {
        this.connectPoints.add(SW1_ETH1);
        this.connectPoints.add(SW2_ETH1);
        this.connectPoints.add(SW3_ETH1);
        this.connectPoints.add(SW4_ETH1);
    }

    @Test
    public void testIntentSync() {
        MultiPointToSinglePointIntent intent1 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"1.1.1.0/24"), "00:00:00:00:00:01", SW1_ETH1);
        MultiPointToSinglePointIntent intent2 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"2.2.2.0/24"), "00:00:00:00:00:02", SW2_ETH1);
        MultiPointToSinglePointIntent intent3 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"3.3.3.0/24"), "00:00:00:00:00:03", SW3_ETH1);
        MultiPointToSinglePointIntent intent4 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"4.4.4.0/24"), "00:00:00:00:00:03", SW3_ETH1);
        MultiPointToSinglePointIntent intent4Update = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"4.4.4.0/24"), "00:00:00:00:00:02", SW2_ETH1);
        MultiPointToSinglePointIntent intent5 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"5.5.5.0/24"), "00:00:00:00:00:01", SW1_ETH1);
        MultiPointToSinglePointIntent intent7 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"7.7.7.0/24"), "00:00:00:00:00:01", SW1_ETH1);
        MultiPointToSinglePointIntent intent6 = this.intentBuilder((IpPrefix)Ip4Prefix.valueOf((String)"6.6.6.0/24"), "00:00:00:00:00:01", SW1_ETH1);
        HashSet<MultiPointToSinglePointIntent> intents = new HashSet<MultiPointToSinglePointIntent>();
        intents.add(intent1);
        EasyMock.expect((Object)this.intentService.getIntentState(intent1.key())).andReturn((Object)IntentState.INSTALLED).anyTimes();
        intents.add(intent2);
        EasyMock.expect((Object)this.intentService.getIntentState(intent2.key())).andReturn((Object)IntentState.INSTALLED).anyTimes();
        intents.add(intent4);
        EasyMock.expect((Object)this.intentService.getIntentState(intent4.key())).andReturn((Object)IntentState.INSTALLED).anyTimes();
        intents.add(intent5);
        EasyMock.expect((Object)this.intentService.getIntentState(intent5.key())).andReturn((Object)IntentState.INSTALLED).anyTimes();
        intents.add(intent7);
        EasyMock.expect((Object)this.intentService.getIntentState(intent7.key())).andReturn((Object)IntentState.WITHDRAWING).anyTimes();
        EasyMock.expect((Object)this.intentService.getIntents()).andReturn(intents).anyTimes();
        this.intentService.withdraw((Intent)intent2);
        this.intentService.submit((Intent)intent3);
        this.intentService.submit((Intent)intent4Update);
        this.intentService.submit((Intent)intent6);
        this.intentService.submit((Intent)intent7);
        EasyMock.replay((Object[])new Object[]{this.intentService});
        this.intentSynchronizer.submit((Intent)intent1);
        this.intentSynchronizer.submit((Intent)intent2);
        this.intentSynchronizer.withdraw((Intent)intent2);
        this.intentSynchronizer.submit((Intent)intent3);
        this.intentSynchronizer.submit((Intent)intent4);
        this.intentSynchronizer.submit((Intent)intent4Update);
        this.intentSynchronizer.submit((Intent)intent5);
        this.intentSynchronizer.submit((Intent)intent6);
        this.intentSynchronizer.submit((Intent)intent7);
        this.intentSynchronizer.modifyPrimary(true);
        EasyMock.verify((Object[])new Object[]{this.intentService});
    }

    @Test
    public void testSubmit() {
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.1.1.0/24");
        MultiPointToSinglePointIntent intent = this.intentBuilder((IpPrefix)prefix, "00:00:00:00:00:01", SW1_ETH1);
        this.intentService.submit((Intent)intent);
        EasyMock.expect((Object)this.intentService.getIntents()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.intentService});
        this.intentSynchronizer.modifyPrimary(true);
        this.intentSynchronizer.submit((Intent)intent);
        EasyMock.verify((Object[])new Object[]{this.intentService});
        EasyMock.reset((Object[])new Object[]{this.intentService});
        EasyMock.replay((Object[])new Object[]{this.intentService});
        this.intentSynchronizer.modifyPrimary(false);
        this.intentSynchronizer.submit((Intent)intent);
        EasyMock.verify((Object[])new Object[]{this.intentService});
    }

    @Test
    public void testWithdraw() {
        Ip4Prefix prefix = Ip4Prefix.valueOf((String)"1.1.1.0/24");
        MultiPointToSinglePointIntent intent = this.intentBuilder((IpPrefix)prefix, "00:00:00:00:00:01", SW1_ETH1);
        this.intentService.submit((Intent)intent);
        this.intentService.withdraw((Intent)intent);
        EasyMock.expect((Object)this.intentService.getIntents()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.intentService});
        this.intentSynchronizer.modifyPrimary(true);
        this.intentSynchronizer.submit((Intent)intent);
        this.intentSynchronizer.withdraw((Intent)intent);
        EasyMock.verify((Object[])new Object[]{this.intentService});
        EasyMock.reset((Object[])new Object[]{this.intentService});
        EasyMock.replay((Object[])new Object[]{this.intentService});
        this.intentSynchronizer.modifyPrimary(false);
        this.intentSynchronizer.submit((Intent)intent);
        this.intentSynchronizer.withdraw((Intent)intent);
        EasyMock.verify((Object[])new Object[]{this.intentService});
    }

    private MultiPointToSinglePointIntent intentBuilder(IpPrefix ipPrefix, String nextHopMacAddress, ConnectPoint egressPoint) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (ipPrefix.isIp4()) {
            selectorBuilder.matchEthType(Ethernet.TYPE_IPV4);
            selectorBuilder.matchIPDst(ipPrefix);
        } else {
            selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
            selectorBuilder.matchIPv6Dst(ipPrefix);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        treatmentBuilder.setEthDst(MacAddress.valueOf((String)nextHopMacAddress));
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>(this.connectPoints);
        ingressPoints.remove(egressPoint);
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(APPID).key(Key.of((String)ipPrefix.toString(), (ApplicationId)APPID)).selector(selectorBuilder.build()).treatment(treatmentBuilder.build()).ingressPoints(ingressPoints).egressPoint(egressPoint).build();
        return intent;
    }

    private class TestClusterService
    extends ClusterServiceAdapter {
        private TestClusterService() {
        }

        public ControllerNode getLocalNode() {
            return LOCAL_NODE;
        }
    }

    private class TestCoreService
    extends CoreServiceAdapter {
        private TestCoreService() {
        }

        public ApplicationId registerApplication(String name) {
            return APPID;
        }
    }

    private class TestIntentSynchronizer
    extends IntentSynchronizer {
        private TestIntentSynchronizer() {
        }

        protected ExecutorService createExecutor() {
            return MoreExecutors.newDirectExecutorService();
        }
    }
}

