/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

public final class BgpConstants {
    public static final int BGP_PORT = 179;
    public static final int BGP_VERSION = 4;
    public static final int BGP_TYPE_OPEN = 1;
    public static final int BGP_TYPE_UPDATE = 2;
    public static final int BGP_TYPE_NOTIFICATION = 3;
    public static final int BGP_TYPE_KEEPALIVE = 4;
    public static final int BGP_HEADER_MARKER_LENGTH = 16;
    public static final int BGP_HEADER_LENGTH = 19;
    public static final int BGP_MESSAGE_MAX_LENGTH = 4096;
    public static final int BGP_OPEN_MIN_LENGTH = 29;
    public static final int BGP_UPDATE_MIN_LENGTH = 23;
    public static final int BGP_NOTIFICATION_MIN_LENGTH = 21;
    public static final int BGP_KEEPALIVE_EXPECTED_LENGTH = 19;
    public static final int BGP_KEEPALIVE_PER_HOLD_INTERVAL = 3;
    public static final int BGP_KEEPALIVE_MIN_HOLDTIME = 3;
    public static final int BGP_KEEPALIVE_MIN_INTERVAL = 1;
    public static final long BGP_AS_0 = 0L;

    private BgpConstants() {
    }

    public static final class Notifications {
        public static final int ERROR_SUBCODE_UNSPECIFIC = 0;

        private Notifications() {
        }

        public static final class HoldTimerExpired {
            public static final int ERROR_CODE = 4;

            private HoldTimerExpired() {
            }
        }

        public static final class UpdateMessageError {
            public static final int ERROR_CODE = 3;
            public static final int MALFORMED_ATTRIBUTE_LIST = 1;
            public static final int UNRECOGNIZED_WELL_KNOWN_ATTRIBUTE = 2;
            public static final int MISSING_WELL_KNOWN_ATTRIBUTE = 3;
            public static final int ATTRIBUTE_FLAGS_ERROR = 4;
            public static final int ATTRIBUTE_LENGTH_ERROR = 5;
            public static final int INVALID_ORIGIN_ATTRIBUTE = 6;
            public static final int INVALID_NEXT_HOP_ATTRIBUTE = 8;
            public static final int OPTIONAL_ATTRIBUTE_ERROR = 9;
            public static final int INVALID_NETWORK_FIELD = 10;
            public static final int MALFORMED_AS_PATH = 11;

            private UpdateMessageError() {
            }
        }

        public static final class OpenMessageError {
            public static final int ERROR_CODE = 2;
            public static final int UNSUPPORTED_VERSION_NUMBER = 1;
            public static final int BAD_PEER_AS = 2;
            public static final int UNACCEPTABLE_HOLD_TIME = 6;

            private OpenMessageError() {
            }
        }

        public static final class MessageHeaderError {
            public static final int ERROR_CODE = 1;
            public static final int CONNECTION_NOT_SYNCHRONIZED = 1;
            public static final int BAD_MESSAGE_LENGTH = 2;
            public static final int BAD_MESSAGE_TYPE = 3;

            private MessageHeaderError() {
            }
        }
    }

    public static final class Update {
        public static final int AS_LENGTH = 2;
        public static final int AS_4OCTET_LENGTH = 4;

        private Update() {
        }

        public static final class MpUnreachNlri {
            public static final int TYPE = 15;
            public static final int MIN_LENGTH = 3;

            private MpUnreachNlri() {
            }
        }

        public static final class MpReachNlri {
            public static final int TYPE = 14;
            public static final int MIN_LENGTH = 5;

            private MpReachNlri() {
            }
        }

        public static final class Aggregator {
            public static final int TYPE = 7;
            public static final int AS2_LENGTH = 6;
            public static final int AS4_LENGTH = 8;

            private Aggregator() {
            }
        }

        public static final class AtomicAggregate {
            public static final int TYPE = 6;
            public static final int LENGTH = 0;

            private AtomicAggregate() {
            }
        }

        public static final class LocalPref {
            public static final int TYPE = 5;
            public static final int LENGTH = 4;

            private LocalPref() {
            }
        }

        public static final class MultiExitDisc {
            public static final int TYPE = 4;
            public static final int LENGTH = 4;
            public static final int LOWEST_MULTI_EXIT_DISC = 0;

            private MultiExitDisc() {
            }
        }

        public static final class NextHop {
            public static final int TYPE = 3;
            public static final int LENGTH = 4;

            private NextHop() {
            }
        }

        public static final class AsPath {
            public static final int TYPE = 2;
            public static final int AS_SET = 1;
            public static final int AS_SEQUENCE = 2;
            public static final int AS_CONFED_SEQUENCE = 3;
            public static final int AS_CONFED_SET = 4;

            private AsPath() {
            }

            public static String typeToString(int type) {
                String typeString = "UNKNOWN";
                switch (type) {
                    case 1: {
                        typeString = "AS_SET";
                        break;
                    }
                    case 2: {
                        typeString = "AS_SEQUENCE";
                        break;
                    }
                    case 3: {
                        typeString = "AS_CONFED_SEQUENCE";
                        break;
                    }
                    case 4: {
                        typeString = "AS_CONFED_SET";
                        break;
                    }
                }
                return typeString;
            }
        }

        public static final class Origin {
            public static final int TYPE = 1;
            public static final int LENGTH = 1;
            public static final int IGP = 0;
            public static final int EGP = 1;
            public static final int INCOMPLETE = 2;

            private Origin() {
            }

            public static String typeToString(int type) {
                String typeString = "UNKNOWN";
                switch (type) {
                    case 0: {
                        typeString = "IGP";
                        break;
                    }
                    case 1: {
                        typeString = "EGP";
                        break;
                    }
                    case 2: {
                        typeString = "INCOMPLETE";
                        break;
                    }
                }
                return typeString;
            }
        }
    }

    public static final class Open {
        private Open() {
        }

        public static final class Capabilities {
            public static final int TYPE = 2;
            public static final int MIN_LENGTH = 2;

            public static final class As4Octet {
                public static final int CODE = 65;
                public static final int LENGTH = 4;
            }

            public static final class MultiprotocolExtensions {
                public static final int CODE = 1;
                public static final int LENGTH = 4;
                public static final int AFI_IPV4 = 1;
                public static final int AFI_IPV6 = 2;
                public static final int SAFI_UNICAST = 1;
                public static final int SAFI_MULTICAST = 2;
            }
        }

        public static final class OptionalParameters {
        }
    }
}

