/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.routing.bgp.BgpKeepalive;
import org.onosproject.routing.bgp.BgpNotification;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpRouteSelector;
import org.onosproject.routing.bgp.BgpSessionInfo;
import org.onosproject.routing.bgp.BgpSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpSession
extends SimpleChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(BgpSession.class);
    private final BgpSessionManager bgpSessionManager;
    private boolean isClosed = false;
    private final BgpSessionInfo localInfo;
    private final BgpSessionInfo remoteInfo;
    private Timer timer = new HashedWheelTimer(Tools.groupedThreads((String)"BgpSession", (String)"timer-%d", (Logger)log));
    private volatile Timeout keepaliveTimeout;
    private volatile Timeout sessionTimeout;
    private ConcurrentMap<Ip4Prefix, BgpRouteEntry> bgpRibIn4 = new ConcurrentHashMap<Ip4Prefix, BgpRouteEntry>();
    private ConcurrentMap<Ip6Prefix, BgpRouteEntry> bgpRibIn6 = new ConcurrentHashMap<Ip6Prefix, BgpRouteEntry>();

    BgpSession(BgpSessionManager bgpSessionManager) {
        this.bgpSessionManager = bgpSessionManager;
        this.localInfo = new BgpSessionInfo();
        this.remoteInfo = new BgpSessionInfo();
        this.localInfo.setBgpVersion(4);
    }

    BgpSessionManager getBgpSessionManager() {
        return this.bgpSessionManager;
    }

    public BgpSessionInfo localInfo() {
        return this.localInfo;
    }

    public BgpSessionInfo remoteInfo() {
        return this.remoteInfo;
    }

    public boolean mpExtensions() {
        return this.remoteInfo.mpExtensions() && this.localInfo.mpExtensions();
    }

    public boolean isAs4OctetCapable() {
        return this.remoteInfo.as4OctetCapability() && this.localInfo.as4OctetCapability();
    }

    public Collection<BgpRouteEntry> getBgpRibIn4() {
        return this.bgpRibIn4.values();
    }

    public Collection<BgpRouteEntry> getBgpRibIn6() {
        return this.bgpRibIn6.values();
    }

    public BgpRouteEntry findBgpRoute(Ip4Prefix prefix) {
        return (BgpRouteEntry)((Object)this.bgpRibIn4.get(prefix));
    }

    public BgpRouteEntry findBgpRoute(Ip6Prefix prefix) {
        return (BgpRouteEntry)((Object)this.bgpRibIn6.get(prefix));
    }

    public BgpRouteEntry findBgpRoute(IpPrefix prefix) {
        if (prefix.isIp4()) {
            Ip4Prefix ip4Prefix = prefix.getIp4Prefix();
            return (BgpRouteEntry)((Object)this.bgpRibIn4.get(ip4Prefix));
        }
        Ip6Prefix ip6Prefix = prefix.getIp6Prefix();
        return (BgpRouteEntry)((Object)this.bgpRibIn6.get(ip6Prefix));
    }

    void addBgpRoute(BgpRouteEntry bgpRouteEntry) {
        if (bgpRouteEntry.isIp4()) {
            Ip4Prefix ip4Prefix = bgpRouteEntry.prefix().getIp4Prefix();
            this.bgpRibIn4.put(ip4Prefix, bgpRouteEntry);
        } else {
            Ip6Prefix ip6Prefix = bgpRouteEntry.prefix().getIp6Prefix();
            this.bgpRibIn6.put(ip6Prefix, bgpRouteEntry);
        }
    }

    boolean removeBgpRoute(Ip4Prefix prefix) {
        return this.bgpRibIn4.remove(prefix) != null;
    }

    boolean removeBgpRoute(Ip6Prefix prefix) {
        return this.bgpRibIn6.remove(prefix) != null;
    }

    boolean removeBgpRoute(IpPrefix prefix) {
        if (prefix.isIp4()) {
            return this.bgpRibIn4.remove(prefix.getIp4Prefix()) != null;
        }
        return this.bgpRibIn6.remove(prefix.getIp6Prefix()) != null;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void closeSession(ChannelHandlerContext ctx) {
        this.timer.stop();
        this.closeChannel(ctx);
    }

    void closeChannel(ChannelHandlerContext ctx) {
        this.isClosed = true;
        ctx.getChannel().close();
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
        this.bgpSessionManager.addSessionChannel(channelEvent.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
        this.bgpSessionManager.removeSessionChannel(channelEvent.getChannel());
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
        InetAddress inetAddr;
        this.localInfo.setAddress(ctx.getChannel().getLocalAddress());
        this.remoteInfo.setAddress(ctx.getChannel().getRemoteAddress());
        if (this.localInfo.address() instanceof InetSocketAddress) {
            inetAddr = ((InetSocketAddress)this.localInfo.address()).getAddress();
            this.localInfo.setIp4Address(Ip4Address.valueOf((byte[])inetAddr.getAddress()));
        }
        if (this.remoteInfo.address() instanceof InetSocketAddress) {
            inetAddr = ((InetSocketAddress)this.remoteInfo.address()).getAddress();
            this.remoteInfo.setIp4Address(Ip4Address.valueOf((byte[])inetAddr.getAddress()));
        }
        log.debug("BGP Session Connected from {} on {}", (Object)this.remoteInfo.address(), (Object)this.localInfo.address());
        if (!this.bgpSessionManager.peerConnected(this)) {
            log.debug("Cannot setup BGP Session Connection from {}. Closing...", (Object)this.remoteInfo.address());
            ctx.getChannel().close();
        }
        this.localInfo.setBgpId(this.bgpSessionManager.getMyBgpId());
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
        log.debug("BGP Session Disconnected from {} on {}", (Object)ctx.getChannel().getRemoteAddress(), (Object)ctx.getChannel().getLocalAddress());
        this.processChannelDisconnected();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        log.debug("BGP Session Exception Caught from {} on {}: {}", new Object[]{ctx.getChannel().getRemoteAddress(), ctx.getChannel().getLocalAddress(), e});
        log.debug("Exception:", e.getCause());
        this.processChannelDisconnected();
    }

    private void processChannelDisconnected() {
        Collection<BgpRouteEntry> deletedRoutes4 = this.bgpRibIn4.values();
        Collection<BgpRouteEntry> deletedRoutes6 = this.bgpRibIn6.values();
        this.bgpRibIn4 = new ConcurrentHashMap<Ip4Prefix, BgpRouteEntry>();
        this.bgpRibIn6 = new ConcurrentHashMap<Ip6Prefix, BgpRouteEntry>();
        BgpRouteSelector bgpRouteSelector = this.bgpSessionManager.getBgpRouteSelector();
        List<BgpRouteEntry> addedRoutes = Collections.emptyList();
        bgpRouteSelector.routeUpdates(addedRoutes, deletedRoutes4);
        bgpRouteSelector.routeUpdates(addedRoutes, deletedRoutes6);
        this.bgpSessionManager.peerDisconnected(this);
    }

    void restartKeepaliveTimer(ChannelHandlerContext ctx) {
        long localKeepaliveInterval = 0L;
        if (this.localInfo.holdtime() != 0L) {
            localKeepaliveInterval = Math.max(this.localInfo.holdtime() / 3L, 1L);
        }
        if (localKeepaliveInterval == 0L) {
            return;
        }
        this.keepaliveTimeout = this.timer.newTimeout((TimerTask)new TransmitKeepaliveTask(ctx), localKeepaliveInterval, TimeUnit.SECONDS);
    }

    void restartSessionTimeoutTimer(ChannelHandlerContext ctx) {
        if (this.remoteInfo.holdtime() == 0L) {
            return;
        }
        if (this.sessionTimeout != null) {
            this.sessionTimeout.cancel();
        }
        this.sessionTimeout = this.timer.newTimeout((TimerTask)new SessionTimeoutTask(ctx), this.remoteInfo.holdtime(), TimeUnit.SECONDS);
    }

    private final class SessionTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        SessionTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            log.debug("BGP Session Timeout: peer {}", (Object)BgpSession.this.remoteInfo.address());
            int errorCode = 4;
            int errorSubcode = 0;
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
            this.ctx.getChannel().write((Object)txMessage);
            BgpSession.this.closeChannel(this.ctx);
        }
    }

    private final class TransmitKeepaliveTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        TransmitKeepaliveTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            ChannelBuffer txMessage = BgpKeepalive.prepareBgpKeepalive();
            this.ctx.getChannel().write((Object)txMessage);
            BgpSession.this.restartKeepaliveTimer(this.ctx);
        }
    }
}

