/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.onlab.packet.Ip4Address;
import org.onosproject.routing.bgp.BgpKeepalive;
import org.onosproject.routing.bgp.BgpMessage;
import org.onosproject.routing.bgp.BgpNotification;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.BgpSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BgpOpen {
    private static final Logger log = LoggerFactory.getLogger(BgpOpen.class);

    private BgpOpen() {
    }

    static void processBgpOpen(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message) {
        int minLength = 10;
        if (message.readableBytes() < minLength) {
            log.debug("BGP RX OPEN Error from {}: Message length {} too short. Must be at least {}", new Object[]{bgpSession.remoteInfo().address(), message.readableBytes(), minLength});
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotificationBadMessageLength(message.readableBytes() + 19);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        short remoteBgpVersion = message.readUnsignedByte();
        if (remoteBgpVersion != 4) {
            log.debug("BGP RX OPEN Error from {}: Unsupported BGP version {}. Should be {}", new Object[]{bgpSession.remoteInfo().address(), (int)remoteBgpVersion, 4});
            int errorCode = 2;
            int errorSubcode = 1;
            ChannelBuffer data = ChannelBuffers.buffer((int)2);
            data.writeShort(4);
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        bgpSession.remoteInfo().setBgpVersion(remoteBgpVersion);
        long remoteAs = message.readUnsignedShort();
        bgpSession.remoteInfo().setAsNumber(remoteAs);
        bgpSession.localInfo().setAsNumber(remoteAs);
        long remoteHoldtime = message.readUnsignedShort();
        if (remoteHoldtime != 0L && remoteHoldtime < 3L) {
            log.debug("BGP RX OPEN Error from {}: Unacceptable Hold Time field {}. Should be 0 or at least {}", new Object[]{bgpSession.remoteInfo().address(), remoteHoldtime, 3});
            int errorCode = 2;
            int errorSubcode = 6;
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        bgpSession.remoteInfo().setHoldtime(remoteHoldtime);
        bgpSession.localInfo().setHoldtime(remoteHoldtime);
        Ip4Address remoteBgpId = Ip4Address.valueOf((int)((int)message.readUnsignedInt()));
        bgpSession.remoteInfo().setBgpId(remoteBgpId);
        try {
            BgpOpen.parseOptionalParameters(bgpSession, ctx, message);
        }
        catch (BgpMessage.BgpParseException e) {
            log.debug("BGP RX OPEN Error from {}: Exception parsing Optional Parameters: {}", (Object)bgpSession.remoteInfo().address(), (Object)e);
            int errorCode = 2;
            int errorSubcode = 0;
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        ChannelBuffer txOpenMessage = BgpOpen.prepareBgpOpen(bgpSession.localInfo());
        if (bgpSession.remoteInfo().as4OctetCapability()) {
            long as4Number = bgpSession.remoteInfo().as4Number();
            bgpSession.remoteInfo().setAsNumber(as4Number);
            bgpSession.localInfo().setAsNumber(as4Number);
        }
        for (BgpSession bs : bgpSession.getBgpSessionManager().getBgpSessions()) {
            if (bs.remoteInfo().asNumber() == 0L || bgpSession.remoteInfo().asNumber() == bs.remoteInfo().asNumber()) continue;
            log.debug("BGP RX OPEN Error from {}: Bad Peer AS {}. Expected {}", new Object[]{bgpSession.remoteInfo().address(), bgpSession.remoteInfo().asNumber(), bs.remoteInfo().asNumber()});
            int errorCode = 2;
            int errorSubcode = 2;
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        log.debug("BGP RX OPEN message from {}: BGPv{} AS {} BGP-ID {} Holdtime {}", new Object[]{bgpSession.remoteInfo().address(), bgpSession.remoteInfo().bgpVersion(), bgpSession.remoteInfo().asNumber(), bgpSession.remoteInfo().bgpId(), bgpSession.remoteInfo().holdtime()});
        ctx.getChannel().write((Object)txOpenMessage);
        ChannelBuffer txMessage = BgpKeepalive.prepareBgpKeepalive();
        ctx.getChannel().write((Object)txMessage);
        bgpSession.restartKeepaliveTimer(ctx);
        bgpSession.restartSessionTimeoutTimer(ctx);
    }

    static ChannelBuffer prepareBgpOpen(BgpSessionInfo localInfo) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        message.writeByte(localInfo.bgpVersion());
        message.writeShort((int)localInfo.asNumber());
        message.writeShort((int)localInfo.holdtime());
        message.writeInt(localInfo.bgpId().toInt());
        ChannelBuffer capabilitiesMessage = BgpOpen.prepareBgpOpenCapabilities(localInfo);
        message.writeByte(capabilitiesMessage.readableBytes());
        message.writeBytes(capabilitiesMessage);
        return BgpMessage.prepareBgpMessage(1, message);
    }

    private static void parseOptionalParameters(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message) throws BgpMessage.BgpParseException {
        short optParamLength = message.readUnsignedByte();
        if (optParamLength > message.readableBytes()) {
            String errorMsg = "Invalid Optional Parameter Length field " + optParamLength + ". Remaining Optional Parameters " + message.readableBytes();
            throw new BgpMessage.BgpParseException(errorMsg);
        }
        if (optParamLength == 0) {
            return;
        }
        int optParamEnd = message.readerIndex() + optParamLength;
        block7: while (message.readerIndex() < optParamEnd) {
            short paramType = message.readUnsignedByte();
            if (message.readerIndex() >= optParamEnd) {
                String errorMsg = "Malformed Optional Parameters";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            short paramLen = message.readUnsignedByte();
            if (message.readerIndex() + paramLen > optParamEnd) {
                String errorMsg = "Malformed Optional Parameters";
                throw new BgpMessage.BgpParseException(errorMsg);
            }
            switch (paramType) {
                case 2: {
                    if (paramLen < 2) {
                        String errorMsg = "Malformed Capabilities Optional Parameter Type " + paramType;
                        throw new BgpMessage.BgpParseException(errorMsg);
                    }
                    int paramEnd = message.readerIndex() + paramLen;
                    block8: while (message.readerIndex() < paramEnd) {
                        if (paramEnd - message.readerIndex() < 2) {
                            String errorMsg = "Malformed Capabilities";
                            throw new BgpMessage.BgpParseException(errorMsg);
                        }
                        short capabCode = message.readUnsignedByte();
                        short capabLen = message.readUnsignedByte();
                        if (message.readerIndex() + capabLen > paramEnd) {
                            String errorMsg = "Malformed Capability instance with code " + capabCode;
                            throw new BgpMessage.BgpParseException(errorMsg);
                        }
                        switch (capabCode) {
                            case 1: {
                                if (capabLen != 4) {
                                    String errorMsg = "Multiprotocol Extension Length Error";
                                    throw new BgpMessage.BgpParseException(errorMsg);
                                }
                                int afi = message.readUnsignedShort();
                                short reserved = message.readUnsignedByte();
                                short safi = message.readUnsignedByte();
                                log.debug("BGP RX OPEN Capability: AFI = {} SAFI = {}", (Object)afi, (Object)safi);
                                if (afi == 1 && safi == 1) {
                                    bgpSession.remoteInfo().setIpv4Unicast();
                                    bgpSession.localInfo().setIpv4Unicast();
                                    continue block8;
                                }
                                if (afi == 1 && safi == 2) {
                                    bgpSession.remoteInfo().setIpv4Multicast();
                                    bgpSession.localInfo().setIpv4Multicast();
                                    continue block8;
                                }
                                if (afi == 2 && safi == 1) {
                                    bgpSession.remoteInfo().setIpv6Unicast();
                                    bgpSession.localInfo().setIpv6Unicast();
                                    continue block8;
                                }
                                if (afi == 2 && safi == 2) {
                                    bgpSession.remoteInfo().setIpv6Multicast();
                                    bgpSession.localInfo().setIpv6Multicast();
                                    continue block8;
                                }
                                log.debug("BGP RX OPEN Capability: Unknown AFI = {} SAFI = {}", (Object)afi, (Object)safi);
                                continue block8;
                            }
                            case 65: {
                                if (capabLen != 4) {
                                    String errorMsg = "4-octet AS Number Capability Length Error";
                                    throw new BgpMessage.BgpParseException(errorMsg);
                                }
                                long as4Number = message.readUnsignedInt();
                                bgpSession.remoteInfo().setAs4OctetCapability();
                                bgpSession.remoteInfo().setAs4Number(as4Number);
                                bgpSession.localInfo().setAs4OctetCapability();
                                bgpSession.localInfo().setAs4Number(as4Number);
                                log.debug("BGP RX OPEN Capability: AS4 Number = {}", (Object)as4Number);
                                continue block8;
                            }
                        }
                        log.debug("BGP RX OPEN Capability Code = {} Length = {}", (Object)capabCode, (Object)capabLen);
                        message.readBytes((int)capabLen);
                    }
                    continue block7;
                }
            }
            log.debug("BGP RX OPEN Parameter Type = {} Length = {}", (Object)paramType, (Object)paramLen);
            message.readBytes((int)paramLen);
        }
    }

    private static ChannelBuffer prepareBgpOpenCapabilities(BgpSessionInfo localInfo) {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        if (localInfo.ipv4Unicast()) {
            message.writeByte(2);
            message.writeByte(6);
            message.writeByte(1);
            message.writeByte(4);
            message.writeShort(1);
            message.writeByte(0);
            message.writeByte(1);
        }
        if (localInfo.ipv4Multicast()) {
            message.writeByte(2);
            message.writeByte(6);
            message.writeByte(1);
            message.writeByte(4);
            message.writeShort(1);
            message.writeByte(0);
            message.writeByte(2);
        }
        if (localInfo.ipv6Unicast()) {
            message.writeByte(2);
            message.writeByte(6);
            message.writeByte(1);
            message.writeByte(4);
            message.writeShort(2);
            message.writeByte(0);
            message.writeByte(1);
        }
        if (localInfo.ipv6Multicast()) {
            message.writeByte(2);
            message.writeByte(6);
            message.writeByte(1);
            message.writeByte(4);
            message.writeShort(2);
            message.writeByte(0);
            message.writeByte(2);
        }
        if (localInfo.as4OctetCapability()) {
            message.writeByte(2);
            message.writeByte(6);
            message.writeByte(65);
            message.writeByte(4);
            message.writeInt((int)localInfo.as4Number());
        }
        return message;
    }
}

