/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.Collection;
import java.util.LinkedList;
import org.onlab.packet.IpPrefix;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.routing.RouteEntry;
import org.onosproject.routing.RouteUpdate;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.BgpSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BgpRouteSelector {
    private static final Logger log = LoggerFactory.getLogger(BgpRouteSelector.class);
    private BgpSessionManager bgpSessionManager;

    BgpRouteSelector(BgpSessionManager bgpSessionManager) {
        this.bgpSessionManager = bgpSessionManager;
    }

    synchronized void routeUpdates(Collection<BgpRouteEntry> addedBgpRouteEntries, Collection<BgpRouteEntry> deletedBgpRouteEntries) {
        RouteUpdate routeUpdate;
        LinkedList<Route> updates = new LinkedList<Route>();
        LinkedList<Route> withdraws = new LinkedList<Route>();
        if (this.bgpSessionManager.isShutdown()) {
            return;
        }
        for (BgpRouteEntry bgpRouteEntry : deletedBgpRouteEntries) {
            routeUpdate = this.processDeletedRoute(bgpRouteEntry);
            this.convertRouteUpdateToRoute(routeUpdate, updates, withdraws);
        }
        for (BgpRouteEntry bgpRouteEntry : addedBgpRouteEntries) {
            routeUpdate = this.processAddedRoute(bgpRouteEntry);
            this.convertRouteUpdateToRoute(routeUpdate, updates, withdraws);
        }
        this.bgpSessionManager.withdraw(withdraws);
        this.bgpSessionManager.update(updates);
    }

    private void convertRouteUpdateToRoute(RouteUpdate routeUpdate, Collection<Route> updates, Collection<Route> withdraws) {
        if (routeUpdate != null) {
            Route route = new Route(Route.Source.BGP, routeUpdate.routeEntry().prefix(), routeUpdate.routeEntry().nextHop());
            if (routeUpdate.type().equals((Object)RouteUpdate.Type.UPDATE)) {
                updates.add(route);
            } else if (routeUpdate.type().equals((Object)RouteUpdate.Type.DELETE)) {
                withdraws.add(route);
            }
        }
    }

    private RouteUpdate processAddedRoute(BgpRouteEntry bgpRouteEntry) {
        BgpRouteEntry bestBgpRouteEntry = this.bgpSessionManager.findBgpRoute(bgpRouteEntry.prefix());
        if (bestBgpRouteEntry == null || bgpRouteEntry.isBetterThan(bestBgpRouteEntry)) {
            this.bgpSessionManager.addBgpRoute(bgpRouteEntry);
            RouteUpdate routeUpdate = new RouteUpdate(RouteUpdate.Type.UPDATE, (RouteEntry)bgpRouteEntry);
            return routeUpdate;
        }
        if (bestBgpRouteEntry.getBgpSession() != bgpRouteEntry.getBgpSession()) {
            return null;
        }
        bestBgpRouteEntry = this.findBestBgpRoute(bgpRouteEntry.prefix());
        if (bestBgpRouteEntry == null) {
            log.debug("BGP next best route for prefix {} is missing. Adding the route that is currently processed.", (Object)bgpRouteEntry.prefix());
            bestBgpRouteEntry = bgpRouteEntry;
        }
        this.bgpSessionManager.addBgpRoute(bestBgpRouteEntry);
        RouteUpdate routeUpdate = new RouteUpdate(RouteUpdate.Type.UPDATE, (RouteEntry)bestBgpRouteEntry);
        return routeUpdate;
    }

    private RouteUpdate processDeletedRoute(BgpRouteEntry bgpRouteEntry) {
        BgpRouteEntry bestBgpRouteEntry = this.bgpSessionManager.findBgpRoute(bgpRouteEntry.prefix());
        if (bgpRouteEntry != bestBgpRouteEntry) {
            return null;
        }
        bestBgpRouteEntry = this.findBestBgpRoute(bgpRouteEntry.prefix());
        if (bestBgpRouteEntry != null) {
            this.bgpSessionManager.addBgpRoute(bestBgpRouteEntry);
            RouteUpdate routeUpdate = new RouteUpdate(RouteUpdate.Type.UPDATE, (RouteEntry)bestBgpRouteEntry);
            return routeUpdate;
        }
        this.bgpSessionManager.removeBgpRoute(bgpRouteEntry.prefix());
        RouteUpdate routeUpdate = new RouteUpdate(RouteUpdate.Type.DELETE, (RouteEntry)bgpRouteEntry);
        return routeUpdate;
    }

    private BgpRouteEntry findBestBgpRoute(IpPrefix prefix) {
        BgpRouteEntry bestRoute = null;
        for (BgpSession bgpSession : this.bgpSessionManager.getBgpSessions()) {
            BgpRouteEntry route = bgpSession.findBgpRoute(prefix);
            if (route == null || bestRoute != null && !route.isBetterThan(bestRoute)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }
}

