/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import java.util.HashSet;
import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.config.BgpConfig;

@Command(scope="onos", name="bgp-speaker-add", description="Adds an internal BGP speaker")
public class AddSpeakerCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="Name of the internal BGP speaker", required=true, multiValued=false)
    private String name = null;
    @Argument(index=1, name="connectionPoint", description="Interface to the BGP speaker", required=true, multiValued=false)
    private String connectionPoint = null;
    @Argument(index=2, name="vlanId", description="VLAN Id of the internal BGP speaker", required=false, multiValued=false)
    private String vlanId = null;
    private VlanId vlanIdObj = null;
    private static final String SPEAKER_ADD_SUCCESS = "Speaker Successfully Added.";

    protected void execute() {
        BgpConfig.BgpSpeakerConfig speaker;
        NetworkConfigService configService = (NetworkConfigService)AddSpeakerCommand.get(NetworkConfigService.class);
        CoreService coreService = (CoreService)AddSpeakerCommand.get(CoreService.class);
        ApplicationId appId = coreService.getAppId("org.onosproject.router");
        BgpConfig config = (BgpConfig)configService.addConfig((Object)appId, BgpConfig.class);
        if (this.name != null && (speaker = config.getSpeakerWithName(this.name)) != null) {
            this.log.debug("Speaker already exists: {}", (Object)this.name);
            return;
        }
        this.vlanIdObj = this.vlanId == null || this.vlanId.isEmpty() ? VlanId.NONE : VlanId.vlanId((short)Short.valueOf(this.vlanId));
        this.addSpeakerToConf(config);
        configService.applyConfig((Object)appId, BgpConfig.class, config.node());
        this.print(SPEAKER_ADD_SUCCESS, new Object[0]);
    }

    private void addSpeakerToConf(BgpConfig config) {
        this.log.debug("Adding new speaker to configuration: {}", (Object)this.name);
        BgpConfig.BgpSpeakerConfig speaker = this.getSpeaker();
        config.addSpeaker(speaker);
    }

    private BgpConfig.BgpSpeakerConfig getSpeaker() {
        ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)this.connectionPoint);
        return new BgpConfig.BgpSpeakerConfig(Optional.ofNullable(this.name), this.vlanIdObj, connectPoint, new HashSet());
    }
}

