/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.PacketUtils;
import org.onosproject.routing.fpm.protocol.NetlinkMessageType;
import org.onosproject.routing.fpm.protocol.RtNetlink;

public final class Netlink {
    public static final int NETLINK_HEADER_LENGTH = 16;
    private final long length;
    private final NetlinkMessageType type;
    private final int flags;
    private final long sequence;
    private final long processPortId;
    private final RtNetlink rtNetlink;

    private Netlink(long length, NetlinkMessageType type, int flags, long sequence, long processPortId, RtNetlink rtNetlink) {
        this.length = length;
        this.type = type;
        this.flags = flags;
        this.sequence = sequence;
        this.processPortId = processPortId;
        this.rtNetlink = rtNetlink;
    }

    public long length() {
        return this.length;
    }

    public NetlinkMessageType type() {
        return this.type;
    }

    public int flags() {
        return this.flags;
    }

    public long sequence() {
        return this.sequence;
    }

    public long processPortId() {
        return this.processPortId;
    }

    public RtNetlink rtNetlink() {
        return this.rtNetlink;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("length", this.length).add("type", (Object)this.type).add("flags", this.flags).add("sequence", this.sequence).add("processPortId", this.processPortId).add("rtNetlink", (Object)this.rtNetlink).toString();
    }

    public static Netlink decode(byte[] buffer, int start, int length) throws DeserializationException {
        PacketUtils.checkInput((byte[])buffer, (int)start, (int)length, (int)16);
        ByteBuffer bb = ByteBuffer.wrap(buffer, start, length);
        long messageLength = Integer.reverseBytes(bb.getInt());
        short type = Short.reverseBytes(bb.getShort());
        short flags = Short.reverseBytes(bb.getShort());
        long sequence = Integer.reverseBytes(bb.getInt());
        long processPortId = Integer.reverseBytes(bb.getInt());
        NetlinkMessageType messageType = NetlinkMessageType.get(type);
        if (messageType == null) {
            throw new DeserializationException("Unsupported Netlink message type: " + type);
        }
        RtNetlink rtNetlink = RtNetlink.decode(buffer, bb.position(), bb.limit() - bb.position());
        return new Netlink(messageLength, messageType, flags, sequence, processPortId, rtNetlink);
    }
}

