/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.onosproject.routing.bgp.BgpMessage;
import org.onosproject.routing.bgp.BgpNotification;
import org.onosproject.routing.bgp.BgpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BgpKeepalive {
    private static final Logger log = LoggerFactory.getLogger(BgpKeepalive.class);

    private BgpKeepalive() {
    }

    static void processBgpKeepalive(BgpSession bgpSession, ChannelHandlerContext ctx, ChannelBuffer message) {
        if (message.readableBytes() + 19 != 19) {
            log.debug("BGP RX KEEPALIVE Error from {}: Invalid total message length {}. Expected {}", new Object[]{bgpSession.remoteInfo().address(), message.readableBytes() + 19, 19});
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotificationBadMessageLength(message.readableBytes() + 19);
            ctx.getChannel().write((Object)txMessage);
            bgpSession.closeSession(ctx);
            return;
        }
        log.trace("BGP RX KEEPALIVE message from {}", (Object)bgpSession.remoteInfo().address());
        bgpSession.restartSessionTimeoutTimer(ctx);
    }

    static ChannelBuffer prepareBgpKeepalive() {
        ChannelBuffer message = ChannelBuffers.buffer((int)4096);
        return BgpMessage.prepareBgpMessage(4, message);
    }
}

