/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.cli;

import java.net.InetSocketAddress;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.routing.fpm.FpmInfoService;

@Command(scope="onos", name="fpm-connections", description="Displays the current FPM connections")
public class FpmConnectionsList
extends AbstractShellCommand {
    private static final String FORMAT = "%s:%s connected since %s";

    protected void execute() {
        FpmInfoService fpmInfo = (FpmInfoService)FpmConnectionsList.get(FpmInfoService.class);
        fpmInfo.peers().forEach((socketAddress, timestamp) -> {
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inet = (InetSocketAddress)socketAddress;
                this.print(FORMAT, new Object[]{inet.getHostString(), inet.getPort(), Tools.timeAgo((long)timestamp)});
            } else {
                this.print("Unknown data format", new Object[0]);
            }
        });
    }
}

