/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.McastConfig;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.impl.NextHop;
import org.onosproject.routing.impl.NextHopGroupKey;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
public class SingleSwitchFibInstaller {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_NAME = "org.onosproject.vrouter";
    private static final int PRIORITY_OFFSET = 100;
    private static final int PRIORITY_MULTIPLIER = 5;
    public static final short ASSIGNED_VLAN = 4094;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteService routeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry networkConfigRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    @Property(name="routeToNextHop", boolValue={false}, label="Install a /32 route to each next hop")
    private boolean routeToNextHop = false;
    private DeviceId deviceId;
    private ConnectPoint controlPlaneConnectPoint;
    private List<String> interfaces;
    private ApplicationId coreAppId;
    private ApplicationId routerAppId;
    private ApplicationId vrouterAppId;
    private final Multiset<IpAddress> nextHopsCount = ConcurrentHashMultiset.create();
    private final Map<IpPrefix, IpAddress> prefixToNextHop = Maps.newHashMap();
    private final Map<IpAddress, Integer> nextHops = Maps.newHashMap();
    private final InternalDeviceListener deviceListener = new InternalDeviceListener();
    private final InternalInterfaceListener internalInterfaceList = new InternalInterfaceListener();
    private final InternalRouteListener routeListener = new InternalRouteListener();
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private ConfigFactory<ApplicationId, McastConfig> mcastConfigFactory = new ConfigFactory<ApplicationId, McastConfig>(SubjectFactories.APP_SUBJECT_FACTORY, McastConfig.class, "multicast"){

        public McastConfig createConfig() {
            return new McastConfig();
        }
    };

    @Activate
    protected void activate(ComponentContext context) {
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.coreAppId = this.coreService.registerApplication("org.onosproject.core");
        this.routerAppId = this.coreService.registerApplication("org.onosproject.router");
        this.vrouterAppId = this.coreService.registerApplication(APP_NAME);
        this.networkConfigRegistry.registerConfigFactory(this.mcastConfigFactory);
        this.networkConfigService.addListener((EventListener)this.configListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.interfaceService.addListener((EventListener)this.internalInterfaceList);
        this.updateConfig();
        this.applicationService.registerDeactivateHook(this.vrouterAppId, () -> this.cleanUp());
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.routeService.removeListener((EventListener)this.routeListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.interfaceService.removeListener((EventListener)this.internalInterfaceList);
        this.networkConfigService.removeListener((EventListener)this.configListener);
        this.componentConfigService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        if (properties == null) {
            return;
        }
        String strRouteToNextHop = Tools.get((Dictionary)properties, (String)"routeToNextHop");
        this.routeToNextHop = Boolean.parseBoolean(strRouteToNextHop);
        this.log.info("routeToNextHop set to {}", (Object)this.routeToNextHop);
    }

    private void cleanUp() {
        this.routeService.removeListener((EventListener)this.routeListener);
        for (Map.Entry<IpPrefix, IpAddress> routes : this.prefixToNextHop.entrySet()) {
            this.deleteRoute(new ResolvedRoute(routes.getKey(), null, null, null));
        }
        Set<Interface> intfs = this.getInterfaces();
        if (!intfs.isEmpty()) {
            this.processIntfFilters(false, intfs);
        }
    }

    private void updateConfig() {
        RouterConfig routerConfig = (RouterConfig)this.networkConfigService.getConfig((Object)this.routerAppId, RoutingService.ROUTER_CONFIG_CLASS);
        if (routerConfig == null) {
            this.log.info("Router config not available");
            return;
        }
        this.controlPlaneConnectPoint = routerConfig.getControlPlaneConnectPoint();
        this.log.info("Control Plane Connect Point: {}", (Object)this.controlPlaneConnectPoint);
        this.deviceId = routerConfig.getControlPlaneConnectPoint().deviceId();
        this.log.info("Router device ID is {}", (Object)this.deviceId);
        this.interfaces = routerConfig.getInterfaces();
        this.log.info("Using interfaces: {}", this.interfaces.isEmpty() ? "all" : this.interfaces);
        this.routeService.addListener((EventListener)this.routeListener);
        this.updateDevice();
    }

    private void removeFilteringObjectives(NetworkConfigEvent event) {
        RouterConfig prevRouterConfig = (RouterConfig)event.prevConfig().get();
        List prevInterfaces = prevRouterConfig.getInterfaces();
        Set<Interface> previntfs = this.filterInterfaces(prevInterfaces);
        if (previntfs.isEmpty() && !this.interfaces.isEmpty()) {
            Set allIntfs = this.interfaceService.getInterfaces();
            for (Interface allIntf : allIntfs) {
                if (this.interfaces.contains(allIntf.name())) continue;
                this.processIntfFilter(false, allIntf);
            }
            return;
        }
        for (Interface prevIntf : previntfs) {
            if (this.interfaces.contains(prevIntf.name())) continue;
            this.processIntfFilter(false, prevIntf);
        }
    }

    private void updateDevice() {
        if (this.deviceId != null && this.deviceService.isAvailable(this.deviceId)) {
            Set<Interface> intfs = this.getInterfaces();
            this.processIntfFilters(true, intfs);
        }
    }

    private Set<Interface> getInterfaces() {
        Set<Interface> intfs = this.interfaces == null || this.interfaces.isEmpty() ? this.interfaceService.getInterfaces() : this.filterInterfaces(this.interfaces);
        return intfs;
    }

    private Set<Interface> filterInterfaces(List<String> interfaces) {
        Set<Interface> intfs = this.interfaceService.getInterfaces().stream().filter(intf -> intf.connectPoint().deviceId().equals((Object)this.deviceId)).filter(intf -> interfaces.contains(intf.name())).collect(Collectors.toSet());
        return intfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoute(ResolvedRoute route) {
        Integer nextId;
        this.addNextHop(route);
        SingleSwitchFibInstaller singleSwitchFibInstaller = this;
        synchronized (singleSwitchFibInstaller) {
            nextId = this.nextHops.get(route.nextHop());
        }
        this.flowObjectiveService.forward(this.deviceId, this.generateRibForwardingObj(route.prefix(), nextId).add());
        this.log.trace("Sending forwarding objective {} -> nextId:{}", (Object)route, (Object)nextId);
    }

    private synchronized void deleteRoute(ResolvedRoute route) {
        this.flowObjectiveService.forward(this.deviceId, this.generateRibForwardingObj(route.prefix(), null).remove());
    }

    private ForwardingObjective.Builder generateRibForwardingObj(IpPrefix prefix, Integer nextId) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(prefix).build();
        int priority = prefix.prefixLength() * 5 + 100;
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.routerAppId).makePermanent().withSelector(selector).withPriority(priority).withFlag(ForwardingObjective.Flag.SPECIFIC);
        if (nextId == null) {
            fwdBuilder.withTreatment(DefaultTrafficTreatment.builder().build());
        } else {
            fwdBuilder.nextStep(nextId.intValue());
        }
        return fwdBuilder;
    }

    private synchronized void addNextHop(ResolvedRoute route) {
        this.prefixToNextHop.put(route.prefix(), route.nextHop());
        if (this.nextHopsCount.count((Object)route.nextHop()) == 0) {
            Interface egressIntf = this.interfaceService.getMatchingInterface(route.nextHop());
            if (egressIntf == null) {
                this.log.warn("no egress interface found for {}", (Object)route);
                return;
            }
            NextHopGroupKey groupKey = new NextHopGroupKey(route.nextHop());
            NextHop nextHop = new NextHop(route.nextHop(), route.nextHopMac(), groupKey);
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthSrc(egressIntf.mac()).setEthDst(nextHop.mac());
            TrafficSelector.Builder metabuilder = null;
            if (!egressIntf.vlan().equals((Object)VlanId.NONE)) {
                treatment.pushVlan().setVlanId(egressIntf.vlan()).setVlanPcp(Byte.valueOf((byte)0));
            } else {
                metabuilder = DefaultTrafficSelector.builder();
                metabuilder.matchVlanId(VlanId.vlanId((short)4094));
            }
            treatment.setOutput(egressIntf.connectPoint().port());
            int nextId = this.flowObjectiveService.allocateNextId();
            DefaultNextObjective.Builder nextBuilder = DefaultNextObjective.builder().withId(nextId).addTreatment(treatment.build()).withType(NextObjective.Type.SIMPLE).fromApp(this.routerAppId);
            if (metabuilder != null) {
                nextBuilder.withMeta(metabuilder.build());
            }
            NextObjective nextObjective = nextBuilder.add();
            this.flowObjectiveService.next(this.deviceId, nextObjective);
            this.nextHops.put(nextHop.ip(), nextId);
            if (this.routeToNextHop) {
                ForwardingObjective fob = this.generateRibForwardingObj(IpPrefix.valueOf((IpAddress)route.nextHop(), (int)32), nextId).add();
                this.flowObjectiveService.forward(this.deviceId, fob);
            }
        }
        this.nextHopsCount.add((Object)route.nextHop());
    }

    private void processIntfFilters(boolean install, Set<Interface> intfs) {
        this.log.info("Processing {} router interfaces", (Object)intfs.size());
        for (Interface intf : intfs) {
            if (!intf.connectPoint().deviceId().equals((Object)this.deviceId)) continue;
            this.createFilteringObjective(install, intf);
            this.createMcastFilteringObjective(install, intf);
        }
    }

    private void processIntfFilter(boolean install, Interface intf) {
        if (!intf.connectPoint().deviceId().equals((Object)this.deviceId)) {
            return;
        }
        if (!this.interfaces.contains(intf.name()) && install) {
            return;
        }
        this.createFilteringObjective(install, intf);
        this.createMcastFilteringObjective(install, intf);
    }

    private void createFilteringObjective(boolean install, Interface intf) {
        VlanId assignedVlan = this.egressVlan().equals((Object)VlanId.NONE) ? VlanId.vlanId((short)4094) : this.egressVlan();
        DefaultFilteringObjective.Builder fob = DefaultFilteringObjective.builder();
        fob.withKey(Criteria.matchInPort((PortNumber)intf.connectPoint().port())).addCondition(Criteria.matchEthDst((MacAddress)intf.mac())).addCondition(Criteria.matchVlanId((VlanId)intf.vlan()));
        fob.withPriority(100);
        if (intf.vlan() == VlanId.NONE) {
            TrafficTreatment tt = DefaultTrafficTreatment.builder().pushVlan().setVlanId(assignedVlan).build();
            fob.withMeta(tt);
        }
        fob.permit().fromApp(this.routerAppId);
        this.sendFilteringObjective(install, (FilteringObjective.Builder)fob, intf);
        if (this.controlPlaneConnectPoint != null) {
            fob.withKey(Criteria.matchInPort((PortNumber)this.controlPlaneConnectPoint.port()));
            this.sendFilteringObjective(install, (FilteringObjective.Builder)fob, intf);
        }
    }

    private void createMcastFilteringObjective(boolean install, Interface intf) {
        VlanId assignedVlan = this.egressVlan().equals((Object)VlanId.NONE) ? VlanId.vlanId((short)4094) : this.egressVlan();
        DefaultFilteringObjective.Builder fob = DefaultFilteringObjective.builder();
        fob.withKey(Criteria.matchInPort((PortNumber)intf.connectPoint().port())).addCondition(Criteria.matchEthDstMasked((MacAddress)MacAddress.IPV4_MULTICAST, (MacAddress)MacAddress.IPV4_MULTICAST_MASK)).addCondition(Criteria.matchVlanId((VlanId)this.ingressVlan()));
        fob.withPriority(100);
        TrafficTreatment tt = DefaultTrafficTreatment.builder().pushVlan().setVlanId(assignedVlan).build();
        fob.withMeta(tt);
        fob.permit().fromApp(this.routerAppId);
        this.sendFilteringObjective(install, (FilteringObjective.Builder)fob, intf);
    }

    private void sendFilteringObjective(boolean install, FilteringObjective.Builder fob, Interface intf) {
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> this.log.info("Installed filter for interface {}", (Object)intf), (objective, error) -> this.log.error("Failed to install filter for interface {}: {}", (Object)intf, error));
        FilteringObjective filter = install ? fob.add((ObjectiveContext)context) : fob.remove((ObjectiveContext)context);
        this.flowObjectiveService.filter(this.deviceId, filter);
    }

    private VlanId ingressVlan() {
        McastConfig mcastConfig = (McastConfig)this.networkConfigService.getConfig((Object)this.coreAppId, McastConfig.class);
        return mcastConfig != null ? mcastConfig.ingressVlan() : VlanId.NONE;
    }

    private VlanId egressVlan() {
        McastConfig mcastConfig = (McastConfig)this.networkConfigService.getConfig((Object)this.coreAppId, McastConfig.class);
        return mcastConfig != null ? mcastConfig.egressVlan() : VlanId.NONE;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindRouteService(RouteService routeService) {
        this.routeService = routeService;
    }

    protected void unbindRouteService(RouteService routeService) {
        if (this.routeService == routeService) {
            this.routeService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindNetworkConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.networkConfigRegistry = networkConfigRegistry;
    }

    protected void unbindNetworkConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.networkConfigRegistry == networkConfigRegistry) {
            this.networkConfigRegistry = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            Interface intf = (Interface)event.subject();
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    if (intf == null) break;
                    SingleSwitchFibInstaller.this.processIntfFilter(true, intf);
                    break;
                }
                case INTERFACE_UPDATED: {
                    break;
                }
                case INTERFACE_REMOVED: {
                    if (intf == null) break;
                    SingleSwitchFibInstaller.this.processIntfFilter(false, intf);
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(RoutingService.ROUTER_CONFIG_CLASS)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: {
                        SingleSwitchFibInstaller.this.updateConfig();
                        if (!event.prevConfig().isPresent()) break;
                        SingleSwitchFibInstaller.this.removeFilteringObjectives(event);
                        break;
                    }
                    case CONFIG_REGISTERED: {
                        break;
                    }
                    case CONFIG_UNREGISTERED: {
                        break;
                    }
                    case CONFIG_REMOVED: {
                        SingleSwitchFibInstaller.this.cleanUp();
                        break;
                    }
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (!SingleSwitchFibInstaller.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                    SingleSwitchFibInstaller.this.log.info("Device connected {}", (Object)((Device)event.subject()).id());
                    if (!((Device)event.subject()).id().equals((Object)SingleSwitchFibInstaller.this.deviceId)) break;
                    SingleSwitchFibInstaller.this.updateDevice();
                    break;
                }
            }
        }
    }

    private class InternalRouteListener
    implements RouteListener {
        private InternalRouteListener() {
        }

        public void event(RouteEvent event) {
            ResolvedRoute route = (ResolvedRoute)event.subject();
            switch ((RouteEvent.Type)event.type()) {
                case ROUTE_ADDED: 
                case ROUTE_UPDATED: {
                    SingleSwitchFibInstaller.this.updateRoute(route);
                    break;
                }
                case ROUTE_REMOVED: {
                    SingleSwitchFibInstaller.this.deleteRoute(route);
                    break;
                }
            }
        }
    }
}

