/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.routing.bgp.BgpRouteEntry;

public class AsPathTest {
    private ArrayList<BgpRouteEntry.PathSegment> generatePathSegments() {
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType = 3;
        ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
        segmentAsNumbers.add(1L);
        segmentAsNumbers.add(2L);
        segmentAsNumbers.add(3L);
        BgpRouteEntry.PathSegment pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 4;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(4L);
        segmentAsNumbers.add(5L);
        segmentAsNumbers.add(6L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 2;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(7L);
        segmentAsNumbers.add(8L);
        segmentAsNumbers.add(9L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 1;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(10L);
        segmentAsNumbers.add(11L);
        segmentAsNumbers.add(12L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        return pathSegments;
    }

    private BgpRouteEntry.AsPath generateAsPath() {
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = this.generatePathSegments();
        BgpRouteEntry.AsPath asPath = new BgpRouteEntry.AsPath(pathSegments);
        return asPath;
    }

    @Test
    public void testConstructor() {
        BgpRouteEntry.AsPath asPath = this.generateAsPath();
        String expectedString = "AsPath{pathSegments=[PathSegment{type=AS_CONFED_SEQUENCE, segmentAsNumbers=[1, 2, 3]}, PathSegment{type=AS_CONFED_SET, segmentAsNumbers=[4, 5, 6]}, PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[7, 8, 9]}, PathSegment{type=AS_SET, segmentAsNumbers=[10, 11, 12]}]}";
        Assert.assertThat((Object)asPath.toString(), (Matcher)Matchers.is((Object)expectedString));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullPathSegments() {
        ArrayList pathSegments = null;
        new BgpRouteEntry.AsPath(pathSegments);
    }

    @Test
    public void testGetFields() {
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = this.generatePathSegments();
        BgpRouteEntry.AsPath asPath = this.generateAsPath();
        Assert.assertThat((Object)asPath.getPathSegments(), (Matcher)Matchers.is(pathSegments));
    }

    @Test
    public void testGetAsPathLength() {
        BgpRouteEntry.AsPath asPath = this.generateAsPath();
        Assert.assertThat((Object)asPath.getAsPathLength(), (Matcher)Matchers.is((Object)4));
        ArrayList pathSegments = new ArrayList();
        asPath = new BgpRouteEntry.AsPath(pathSegments);
        Assert.assertThat((Object)asPath.getAsPathLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testEquality() {
        BgpRouteEntry.AsPath asPath1 = this.generateAsPath();
        BgpRouteEntry.AsPath asPath2 = this.generateAsPath();
        Assert.assertThat((Object)asPath1, (Matcher)Matchers.is((Object)asPath2));
    }

    @Test
    public void testNonEquality() {
        BgpRouteEntry.AsPath asPath1 = this.generateAsPath();
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = new ArrayList<BgpRouteEntry.PathSegment>();
        byte pathSegmentType = 3;
        ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
        segmentAsNumbers.add(1L);
        segmentAsNumbers.add(2L);
        segmentAsNumbers.add(3L);
        BgpRouteEntry.PathSegment pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 4;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(4L);
        segmentAsNumbers.add(5L);
        segmentAsNumbers.add(6L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 2;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(7L);
        segmentAsNumbers.add(8L);
        segmentAsNumbers.add(9L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        pathSegmentType = 1;
        segmentAsNumbers = new ArrayList();
        segmentAsNumbers.add(10L);
        segmentAsNumbers.add(111L);
        segmentAsNumbers.add(12L);
        pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        pathSegments.add(pathSegment);
        BgpRouteEntry.AsPath asPath2 = new BgpRouteEntry.AsPath(pathSegments);
        Assert.assertThat((Object)asPath1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)asPath2)));
    }

    @Test
    public void testToString() {
        BgpRouteEntry.AsPath asPath = this.generateAsPath();
        String expectedString = "AsPath{pathSegments=[PathSegment{type=AS_CONFED_SEQUENCE, segmentAsNumbers=[1, 2, 3]}, PathSegment{type=AS_CONFED_SET, segmentAsNumbers=[4, 5, 6]}, PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[7, 8, 9]}, PathSegment{type=AS_SET, segmentAsNumbers=[10, 11, 12]}]}";
        Assert.assertThat((Object)asPath.toString(), (Matcher)Matchers.is((Object)expectedString));
    }
}

