/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IpAddress;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RouteAttributeDecoder;

public final class RouteAttributeDst
extends RouteAttribute {
    private final IpAddress dstAddress;

    private RouteAttributeDst(int length, int type, IpAddress dstAddress) {
        super(length, type);
        this.dstAddress = dstAddress;
    }

    public IpAddress dstAddress() {
        return this.dstAddress;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", this.type()).add("length", this.length()).add("dstAddress", (Object)this.dstAddress).toString();
    }

    public static RouteAttributeDecoder<RouteAttributeDst> decoder() {
        return (length, type, value) -> {
            IpAddress dstAddress;
            if (value.length == 4) {
                dstAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
            } else if (value.length == 16) {
                dstAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
            } else {
                throw new DeserializationException("Invalid address length");
            }
            return new RouteAttributeDst(length, type, dstAddress);
        };
    }
}

