/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.routing.bgp.BgpRouteEntry;

public class PathSegmentTest {
    private BgpRouteEntry.PathSegment generatePathSegment() {
        byte pathSegmentType = 2;
        ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
        segmentAsNumbers.add(1L);
        segmentAsNumbers.add(2L);
        segmentAsNumbers.add(3L);
        BgpRouteEntry.PathSegment pathSegment = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        return pathSegment;
    }

    @Test
    public void testConstructor() {
        BgpRouteEntry.PathSegment pathSegment = this.generatePathSegment();
        String expectedString = "PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[1, 2, 3]}";
        Assert.assertThat((Object)pathSegment.toString(), (Matcher)Matchers.is((Object)expectedString));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullSegmentAsNumbers() {
        byte pathSegmentType = 2;
        ArrayList segmentAsNumbers = null;
        new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
    }

    @Test
    public void testGetFields() {
        byte pathSegmentType = 2;
        ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
        segmentAsNumbers.add(1L);
        segmentAsNumbers.add(2L);
        segmentAsNumbers.add(3L);
        BgpRouteEntry.PathSegment pathSegment = this.generatePathSegment();
        Assert.assertThat((Object)pathSegment.getType(), (Matcher)Matchers.is((Object)pathSegmentType));
        Assert.assertThat((Object)pathSegment.getSegmentAsNumbers(), (Matcher)Matchers.is(segmentAsNumbers));
    }

    @Test
    public void testEquality() {
        BgpRouteEntry.PathSegment pathSegment1 = this.generatePathSegment();
        BgpRouteEntry.PathSegment pathSegment2 = this.generatePathSegment();
        Assert.assertThat((Object)pathSegment1, (Matcher)Matchers.is((Object)pathSegment2));
    }

    @Test
    public void testNonEquality() {
        BgpRouteEntry.PathSegment pathSegment1 = this.generatePathSegment();
        byte pathSegmentType = 2;
        ArrayList<Long> segmentAsNumbers = new ArrayList<Long>();
        segmentAsNumbers.add(1L);
        segmentAsNumbers.add(22L);
        segmentAsNumbers.add(3L);
        BgpRouteEntry.PathSegment pathSegment2 = new BgpRouteEntry.PathSegment(pathSegmentType, segmentAsNumbers);
        Assert.assertThat((Object)pathSegment1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)pathSegment2)));
    }

    @Test
    public void testToString() {
        BgpRouteEntry.PathSegment pathSegment = this.generatePathSegment();
        String expectedString = "PathSegment{type=AS_SEQUENCE, segmentAsNumbers=[1, 2, 3]}";
        Assert.assertThat((Object)pathSegment.toString(), (Matcher)Matchers.is((Object)expectedString));
    }
}

