/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.routing.config.BgpConfig;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="bgp-speakers", description="Lists all BGP speakers")
public class BgpSpeakersListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "port=%s/%s, vlan=%s, peers=%s";
    private static final String NAME_FORMAT = "%s: port=%s/%s, vlan=%s, peers=%s";
    private static final Comparator<BgpConfig.BgpSpeakerConfig> SPEAKERS_COMPARATOR = (s1, s2) -> Comparators.CONNECT_POINT_COMPARATOR.compare(s1.connectPoint(), s2.connectPoint());

    protected void execute() {
        CoreService coreService;
        ApplicationId appId;
        NetworkConfigService configService = (NetworkConfigService)BgpSpeakersListCommand.get(NetworkConfigService.class);
        BgpConfig config = (BgpConfig)configService.getConfig((Object)(appId = (coreService = (CoreService)BgpSpeakersListCommand.get(CoreService.class)).getAppId("org.onosproject.router")), BgpConfig.class);
        if (config == null) {
            this.print("No speakers configured", new Object[0]);
            return;
        }
        ArrayList bgpSpeakers = Lists.newArrayList((Iterable)config.bgpSpeakers());
        Collections.sort(bgpSpeakers, SPEAKERS_COMPARATOR);
        if (config.bgpSpeakers().isEmpty()) {
            this.print("No speakers configured", new Object[0]);
        } else {
            bgpSpeakers.forEach(s -> {
                if (s.name().isPresent()) {
                    this.print(NAME_FORMAT, new Object[]{s.name().get(), s.connectPoint().deviceId(), s.connectPoint().port(), s.vlan(), s.peers()});
                } else {
                    this.print(FORMAT, new Object[]{s.connectPoint().deviceId(), s.connectPoint().port(), s.vlan(), s.peers()});
                }
            });
        }
    }
}

