/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.DeviceId;

public final class GatewayNode {
    private final DeviceId gatewayDeviceId;
    private final String uplinkIntf;
    private final Ip4Address dataIpAddress;

    private GatewayNode(DeviceId gatewayDeviceId, String uplinkIntf, Ip4Address dataIpAddress) {
        this.gatewayDeviceId = gatewayDeviceId;
        this.uplinkIntf = uplinkIntf;
        this.dataIpAddress = dataIpAddress;
    }

    public DeviceId getGatewayDeviceId() {
        return this.gatewayDeviceId;
    }

    public String getUplinkIntf() {
        return this.uplinkIntf;
    }

    public Ip4Address getDataIpAddress() {
        return this.dataIpAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GatewayNode) {
            GatewayNode that = (GatewayNode)obj;
            if (Objects.equals(this.gatewayDeviceId, that.gatewayDeviceId) && Objects.equals(this.uplinkIntf, that.uplinkIntf) && Objects.equals(this.dataIpAddress, that.dataIpAddress)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.gatewayDeviceId, this.uplinkIntf, this.dataIpAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("gatewayDeviceId", (Object)this.gatewayDeviceId).add("uplinkInterface", (Object)this.uplinkIntf).add("dataIpAddress", (Object)this.dataIpAddress).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceId gatewayDeviceId;
        private String uplinkIntf;
        private Ip4Address dataIpAddress;

        public Builder gatewayDeviceId(DeviceId deviceId) {
            this.gatewayDeviceId = deviceId;
            return this;
        }

        public Builder uplinkIntf(String name) {
            this.uplinkIntf = name;
            return this;
        }

        public Builder dataIpAddress(Ip4Address address) {
            this.dataIpAddress = address;
            return this;
        }

        public GatewayNode build() {
            return new GatewayNode((DeviceId)Preconditions.checkNotNull((Object)this.gatewayDeviceId), (String)Preconditions.checkNotNull((Object)this.uplinkIntf), (Ip4Address)Preconditions.checkNotNull((Object)this.dataIpAddress));
        }
    }
}

