/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.onlab.packet.Ip4Address;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;
import org.onosproject.scalablegateway.api.GatewayNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayNodeConfig
extends Config<ApplicationId> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String NODES = "nodes";
    public static final String BRIDGE_ID = "bridgeId";
    public static final String DATAPLANE_IP = "dataPlaneIp";
    public static final String UPLINK_INTERFACE_NAME = "uplinkInterface";

    public Set<GatewayNode> gatewayNodes() {
        HashSet nodes = Sets.newHashSet();
        JsonNode jsonNodes = this.object.get(NODES);
        if (jsonNodes == null) {
            return null;
        }
        jsonNodes.forEach(jsonNode -> {
            try {
                nodes.add(new GatewayNode.Builder().gatewayDeviceId(DeviceId.deviceId((String)jsonNode.path(BRIDGE_ID).asText())).uplinkIntf(jsonNode.path(UPLINK_INTERFACE_NAME).asText()).dataIpAddress(Ip4Address.valueOf((String)jsonNode.path(DATAPLANE_IP).asText())).build());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                this.log.error("Failed to read {}", (Object)e.toString());
            }
        });
        return nodes;
    }

    public boolean isValid() {
        JsonNode jsonNodes = this.object.get(NODES);
        if (jsonNodes == null) {
            return false;
        }
        return this.hasOnlyFields(new String[]{NODES}) && StreamSupport.stream(jsonNodes.spliterator(), false).allMatch(this::checkValid);
    }

    private boolean checkValid(JsonNode jsonNode) {
        ObjectNode objectNode = (ObjectNode)jsonNode;
        return this.isString(objectNode, BRIDGE_ID, Config.FieldPresence.MANDATORY, new String[0]) && this.isIpAddress(objectNode, DATAPLANE_IP, Config.FieldPresence.MANDATORY) && this.isString(objectNode, UPLINK_INTERFACE_NAME, Config.FieldPresence.MANDATORY, new String[0]);
    }
}

