/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.Ip4Address;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.scalablegateway.api.GatewayNode;
import org.onosproject.scalablegateway.api.ScalableGatewayService;

@Command(scope="onos", name="gateway-add", description="Adds gateway node information for scalablegateway node managements")
public class ScalableGatewayAddCommand
extends AbstractShellCommand {
    private static final String SUCCESS = "Process of adding gateway node is succeed";
    private static final String FAIL = "Process of adding gateway node is failed";
    @Argument(index=0, name="DeviceId", description="GatewayNode device id", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=1, name="dataPlaneIp", description="GatewayNode datePlane interface ip address", required=true, multiValued=false)
    String ipAddress = null;
    @Argument(index=2, name="extInterfaceNames", description="GatewayNode Interface name to outgoing external network", required=true, multiValued=true)
    String interfaceName = null;

    protected void execute() {
        GatewayNode gatewayNode;
        ScalableGatewayService service = (ScalableGatewayService)ScalableGatewayAddCommand.get(ScalableGatewayService.class);
        if (service.addGatewayNode(gatewayNode = GatewayNode.builder().gatewayDeviceId(DeviceId.deviceId((String)this.deviceId)).dataIpAddress(Ip4Address.valueOf((String)this.ipAddress)).uplinkIntf(this.interfaceName).build())) {
            this.print(SUCCESS, new Object[0]);
        } else {
            this.print(FAIL, new Object[0]);
        }
    }
}

