/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.scalablegateway.api.GatewayNode;
import org.onosproject.scalablegateway.api.GatewayNodeConfig;
import org.onosproject.scalablegateway.api.ScalableGatewayService;
import org.onosproject.scalablegateway.impl.SelectGroupHandler;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class ScalableGatewayManager
implements ScalableGatewayService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    private static final String APP_ID = "org.onosproject.scalablegateway";
    private static final String APP_NAME = "scalablegateway";
    private static final String GATEWAYNODE_MAP_NAME = "gatewaynode-map";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry configRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private GatewayNodeConfig config;
    private SelectGroupHandler selectGroupHandler;
    private final NetworkConfigListener configListener = new InternalConfigListener();
    private final InternalDeviceListener internalDeviceListener = new InternalDeviceListener();
    private final ConfigFactory configFactory = new ConfigFactory(SubjectFactories.APP_SUBJECT_FACTORY, GatewayNodeConfig.class, "scalablegateway"){

        public GatewayNodeConfig createConfig() {
            return new GatewayNodeConfig();
        }
    };
    private ConsistentMap<DeviceId, GatewayNode> gatewayNodeMap;
    private static final KryoNamespace.Builder GATEWAYNODE_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{GatewayNode.class});

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.gatewayNodeMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)GATEWAYNODE_SERIALIZER.build()))).withName(GATEWAYNODE_MAP_NAME)).withApplicationId(this.appId)).build();
        this.configRegistry.registerConfigFactory(this.configFactory);
        this.configService.addListener((EventListener)this.configListener);
        this.deviceService.addListener((EventListener)this.internalDeviceListener);
        this.selectGroupHandler = new SelectGroupHandler(this.groupService, this.deviceService, this.driverService, this.appId);
        this.log.info("started");
    }

    @Deactivate
    protected void deactivate() {
        this.deviceService.removeListener((EventListener)this.internalDeviceListener);
        this.configService.removeListener((EventListener)this.configListener);
        this.log.info("stopped");
    }

    @Override
    public GatewayNode getGatewayNode(DeviceId deviceId) {
        GatewayNode gatewayNode = (GatewayNode)this.gatewayNodeMap.get((Object)deviceId).value();
        if (gatewayNode == null) {
            this.log.warn("Gateway with device ID {} does not exist");
            return null;
        }
        return gatewayNode;
    }

    @Override
    public PortNumber getUplinkPort(DeviceId deviceId) {
        GatewayNode gatewayNode = (GatewayNode)this.gatewayNodeMap.get((Object)deviceId).value();
        if (gatewayNode == null) {
            this.log.warn("Gateway with device ID {} does not exist");
            return null;
        }
        Optional<Port> port = this.deviceService.getPorts(deviceId).stream().filter(p -> Objects.equals(p.annotations().value("portName"), gatewayNode.getUplinkIntf())).findFirst();
        if (!port.isPresent()) {
            this.log.warn("Cannot find uplink interface from gateway {}", (Object)deviceId);
            return null;
        }
        return port.get().number();
    }

    @Override
    public synchronized GroupId getGatewayGroupId(DeviceId srcDeviceId) {
        GroupKey groupKey = this.selectGroupHandler.getGroupKey(srcDeviceId);
        Group group = this.groupService.getGroup(srcDeviceId, groupKey);
        if (group == null) {
            this.log.info("Created gateway group for {}", (Object)srcDeviceId);
            return this.selectGroupHandler.createGatewayGroup(srcDeviceId, this.getGatewayNodes());
        }
        return group.id();
    }

    @Override
    public List<GatewayNode> getGatewayNodes() {
        ArrayList gatewayNodeList = Lists.newArrayList();
        this.gatewayNodeMap.values().stream().map(Versioned::value).forEach(gatewayNodeList::add);
        return gatewayNodeList;
    }

    @Override
    public List<DeviceId> getGatewayDeviceIds() {
        ArrayList deviceIdList = Lists.newArrayList();
        this.gatewayNodeMap.values().stream().map(Versioned::value).forEach(gatewayNode -> deviceIdList.add(gatewayNode.getGatewayDeviceId()));
        return deviceIdList;
    }

    @Override
    public synchronized boolean addGatewayNode(GatewayNode gatewayNode) {
        Versioned existingNode = this.gatewayNodeMap.put((Object)gatewayNode.getGatewayDeviceId(), (Object)gatewayNode);
        if (existingNode == null) {
            this.updateGatewayGroup(gatewayNode, true);
            this.log.info("Gateway {} is added to Gateway pool", (Object)gatewayNode);
            return true;
        }
        if (!((GatewayNode)existingNode.value()).equals(gatewayNode)) {
            this.updateGatewayGroup((GatewayNode)existingNode.value(), false);
            this.updateGatewayGroup(gatewayNode, true);
            this.log.info("Gateway {} is updated", (Object)gatewayNode);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean deleteGatewayNode(GatewayNode gatewayNode) {
        boolean result = this.gatewayNodeMap.remove((Object)gatewayNode.getGatewayDeviceId(), (Object)gatewayNode);
        if (result) {
            this.updateGatewayGroup(gatewayNode, false);
            this.log.info("Deleted gateway with device ID {}", (Object)gatewayNode.getGatewayDeviceId());
        }
        return result;
    }

    private void updateGatewayGroup(GatewayNode gatewayNode, boolean isInsert) {
        Tools.stream((Iterable)this.deviceService.getAvailableDevices()).forEach(device -> Tools.stream((Iterable)this.groupService.getGroups(device.id(), this.appId)).forEach(group -> {
            this.selectGroupHandler.updateGatewayGroupBuckets(device.id(), (List<GatewayNode>)ImmutableList.of((Object)gatewayNode), isInsert);
            this.log.trace("Updated gateway group on {}", (Object)device.id());
        }));
    }

    private void readConfiguration() {
        this.config = (GatewayNodeConfig)this.configService.getConfig((Object)this.appId, GatewayNodeConfig.class);
        if (this.config == null) {
            this.log.error("No configuration found");
            return;
        }
        this.config.gatewayNodes().forEach(this::addGatewayNode);
        this.log.info("ScalableGateway configured");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.configRegistry = networkConfigRegistry;
    }

    protected void unbindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.configRegistry == networkConfigRegistry) {
            this.configRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent deviceEvent) {
            if (deviceEvent.type() == DeviceEvent.Type.DEVICE_SUSPENDED || deviceEvent.type() == DeviceEvent.Type.DEVICE_REMOVED) {
                DeviceId deviceId = ((Device)deviceEvent.subject()).id();
                ScalableGatewayManager.this.deleteGatewayNode(ScalableGatewayManager.this.getGatewayNode(deviceId));
                ScalableGatewayManager.this.log.warn("Gateway with device ID {} is disconnected", (Object)deviceId);
            }
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (!event.configClass().equals(GatewayNodeConfig.class)) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_UPDATED: {
                    ScalableGatewayManager.this.gatewayNodeMap.clear();
                    ScalableGatewayManager.this.readConfiguration();
                    break;
                }
                case CONFIG_ADDED: {
                    ScalableGatewayManager.this.readConfiguration();
                    break;
                }
                default: {
                    ScalableGatewayManager.this.log.debug("Unsupportable event type is occurred");
                }
            }
        }
    }
}

