/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.demo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.demo.DemoApi;
import org.onosproject.demo.DemoInstaller;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DemoInstaller
implements DemoApi {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowService;
    private ExecutorService worker;
    private ExecutorService installWorker;
    private ApplicationId appId;
    private final Set<Intent> existingIntents = new HashSet();
    private RandomInstaller randomInstaller;
    private ObjectMapper mapper = new ObjectMapper();

    @Activate
    public void activate() {
        String nodeId = this.clusterService.getLocalNode().ip().toString();
        this.appId = this.coreService.registerApplication("org.onosproject.demo.installer." + nodeId);
        this.worker = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("demo-app-worker").build());
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.shutdownAndAwaitTermination(this.worker);
        if (this.installWorker != null && !this.installWorker.isShutdown()) {
            this.shutdownAndAwaitTermination(this.installWorker);
        }
        this.log.info("Stopped");
    }

    public JsonNode flowTest(Optional<JsonNode> params) {
        int flowsPerDevice = 1000;
        int neighbours = 0;
        boolean remove = true;
        if (params.isPresent()) {
            flowsPerDevice = params.get().get("flowsPerDevice").asInt();
            neighbours = params.get().get("neighbours").asInt();
            remove = params.get().get("remove").asBoolean();
        }
        Future future = this.worker.submit(new FlowTest(this, flowsPerDevice, neighbours, remove));
        try {
            return (JsonNode)future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("Error", e.getMessage());
            return node;
        }
    }

    public void setup(DemoApi.InstallType type, Optional<JsonNode> runParams) {
        switch (1.$SwitchMap$org$onosproject$demo$DemoApi$InstallType[type.ordinal()]) {
            case 1: {
                this.log.debug("Installing mesh intents");
                this.worker.execute((Runnable)new MeshInstaller(this, null));
                break;
            }
            case 2: {
                if (this.installWorker == null || this.installWorker.isShutdown()) {
                    this.installWorker = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("random-worker").build());
                    this.log.debug("Installing random sequence of intents");
                    this.randomInstaller = new RandomInstaller(this, runParams);
                    this.installWorker.execute((Runnable)this.randomInstaller);
                    break;
                }
                this.log.warn("Random installer is already running");
                break;
            }
            default: {
                throw new IllegalArgumentException("What is it you want exactly?");
            }
        }
    }

    public void tearDown() {
        this.worker.submit((Runnable)new UnInstaller(this, null));
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.log.error("Pool did not terminate");
                }
            }
        }
        catch (Exception ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ ApplicationId access$200(DemoInstaller x0) {
        return x0.appId;
    }

    static /* synthetic */ Set access$300(DemoInstaller x0) {
        return x0.existingIntents;
    }

    static /* synthetic */ ExecutorService access$400(DemoInstaller x0) {
        return x0.installWorker;
    }

    static /* synthetic */ Logger access$500(DemoInstaller x0) {
        return x0.log;
    }

    static /* synthetic */ void access$600(DemoInstaller x0, ExecutorService x1) {
        x0.shutdownAndAwaitTermination(x1);
    }

    static /* synthetic */ RandomInstaller access$700(DemoInstaller x0) {
        return x0.randomInstaller;
    }

    static /* synthetic */ ObjectMapper access$800(DemoInstaller x0) {
        return x0.mapper;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowService(FlowRuleService flowRuleService) {
        this.flowService = flowRuleService;
    }

    protected void unbindFlowService(FlowRuleService flowRuleService) {
        if (this.flowService == flowRuleService) {
            this.flowService = null;
        }
    }
}

