/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.election;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ElectionTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ELECTION_APP = "org.onosproject.election";
    private ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    private LeadershipEventListener leadershipEventListener = new InnerLeadershipEventListener();
    private NodeId localNodeId;

    @Activate
    protected void activate() {
        this.log.info("Election-test app started");
        this.appId = this.coreService.registerApplication(ELECTION_APP);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
    }

    @Deactivate
    protected void deactivate() {
        this.leadershipService.withdraw(this.appId.name());
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        this.log.info("Election-test app Stopped");
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    private class InnerLeadershipEventListener
    implements LeadershipEventListener {
        private InnerLeadershipEventListener() {
        }

        public void event(LeadershipEvent event) {
            if (((LeadershipEvent.Type)event.type()).equals((Object)LeadershipEvent.Type.CANDIDATES_CHANGED)) {
                return;
            }
            if (!((Leadership)event.subject()).topic().equals(ElectionTest.this.appId.name())) {
                return;
            }
            ElectionTest.this.log.debug("Leadership Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_CHANGED: 
                case LEADER_AND_CANDIDATES_CHANGED: {
                    ElectionTest.this.log.info("Election-test app leader changed. New leadership: {}", event.subject());
                    break;
                }
            }
        }
    }
}

