/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.election.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;

@Command(scope="onos", name="election-test-leader", description="Get the current leader for the Election test application")
public class ElectionTestLeaderCommand
extends AbstractShellCommand {
    private NodeId leader;
    private static final String ELECTION_APP = "org.onosproject.election";

    protected void execute() {
        LeadershipService service = (LeadershipService)ElectionTestLeaderCommand.get(LeadershipService.class);
        this.leader = service.getLeader(ELECTION_APP);
        this.printLeader(this.leader);
    }

    private void printLeader(NodeId leader) {
        if (leader != null) {
            this.print("The current leader for the Election app is %s.", new Object[]{leader});
        } else {
            this.print("There is currently no leader elected for the Election app", new Object[0]);
        }
    }
}

