/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.transactionperf;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={TransactionPerfApp.class})
public class TransactionPerfApp {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    private static final String DEFAULT_MAP_NAME = "transaction-perf";
    private static final double DEFAULT_READ_PERCENTAGE = 0.9;
    private static final int DEFAULT_TOTAL_OPERATIONS = 1000;
    private static final boolean DEFAULT_WITH_CONTENTION = false;
    private static final boolean DEFAULT_WITH_RETRIES = false;
    private static final int DEFAULT_REPORT_INTERVAL_SECONDS = 1;
    private static final String KEY_PREFIX = "key";
    @Property(name="mapName", value={"transaction-perf"}, label="The name of the map to use for testing")
    protected String mapName = "transaction-perf";
    @Property(name="readPercentage", doubleValue={0.9}, label="Percentage of reads to perform")
    protected double readPercentage = 0.9;
    @Property(name="totalOperationsPerTransaction", intValue={1000}, label="Number of operations to perform within each transaction")
    protected int totalOperationsPerTransaction = 1000;
    @Property(name="withContention", boolValue={false}, label="Whether to test transactions with contention from all nodes")
    protected boolean withContention = false;
    @Property(name="withRetries", boolValue={false}, label="Whether to retry transactions until success")
    protected boolean withRetries = false;
    @Property(name="reportIntervalSeconds", intValue={1}, label="The frequency with which to report performance in seconds")
    protected int reportIntervalSeconds = 1;
    private ExecutorService testRunner = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"app/transaction-perf-test-runner", (String)""));
    private ScheduledExecutorService reporter = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/transaction-perf-test", (String)"reporter"));
    private Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);
    private AtomicInteger attempted = new AtomicInteger(0);
    private AtomicInteger succeeded = new AtomicInteger(0);
    private AtomicInteger iteration = new AtomicInteger(0);

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(this.getClass());
        if (this.isParticipant()) {
            this.startTest();
            this.reporter.scheduleWithFixedDelay(this::reportPerformance, this.reportIntervalSeconds, this.reportIntervalSeconds, TimeUnit.SECONDS);
            this.logConfig("Started");
        }
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean modified;
        if (context == null) {
            this.mapName = DEFAULT_MAP_NAME;
            this.readPercentage = 0.9;
            this.totalOperationsPerTransaction = 1000;
            this.withContention = false;
            this.withRetries = false;
            this.reportIntervalSeconds = 1;
            return;
        }
        Dictionary properties = context.getProperties();
        String newMapName = this.mapName;
        double newReadPercentage = this.readPercentage;
        int newTotalOperationsPerTransaction = this.totalOperationsPerTransaction;
        boolean newWithContention = this.withContention;
        boolean newWithRetries = this.withRetries;
        int newReportIntervalSeconds = this.reportIntervalSeconds;
        try {
            String s = Tools.get((Dictionary)properties, (String)"mapName");
            if (!Strings.isNullOrEmpty((String)s)) {
                newMapName = s;
            }
            if (!Strings.isNullOrEmpty((String)(s = Tools.get((Dictionary)properties, (String)"readPercentage")))) {
                newReadPercentage = Double.parseDouble(s);
            }
            if (!Strings.isNullOrEmpty((String)(s = Tools.get((Dictionary)properties, (String)"totalOperationsPerTransaction")))) {
                newTotalOperationsPerTransaction = Integer.parseInt(s);
            }
            if (!Strings.isNullOrEmpty((String)(s = Tools.get((Dictionary)properties, (String)"withContention")))) {
                newWithContention = Boolean.parseBoolean(s);
            }
            if (!Strings.isNullOrEmpty((String)(s = Tools.get((Dictionary)properties, (String)"withRetries")))) {
                newWithRetries = Boolean.parseBoolean(s);
            }
            if (!Strings.isNullOrEmpty((String)(s = Tools.get((Dictionary)properties, (String)"reportIntervalSeconds")))) {
                newReportIntervalSeconds = Integer.parseInt(s);
            }
        }
        catch (ClassCastException | NumberFormatException e) {
            return;
        }
        boolean bl = modified = newMapName != this.mapName || newReadPercentage != this.readPercentage || newTotalOperationsPerTransaction != this.totalOperationsPerTransaction || newWithContention != this.withContention || newWithRetries != this.withRetries || newReportIntervalSeconds != this.reportIntervalSeconds;
        if (!modified) {
            return;
        }
        this.mapName = newMapName;
        this.readPercentage = newReadPercentage;
        this.totalOperationsPerTransaction = newTotalOperationsPerTransaction;
        this.withContention = newWithContention;
        this.withRetries = newWithRetries;
        this.reportIntervalSeconds = newReportIntervalSeconds;
        this.stopTest();
        this.testRunner = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"app/transaction-perf-test-runner", (String)""));
        this.reporter = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/transaction-perf-test", (String)"reporter"));
        this.startTest();
        this.reporter.scheduleWithFixedDelay(this::reportPerformance, this.reportIntervalSeconds, this.reportIntervalSeconds, TimeUnit.SECONDS);
        this.logConfig("Restarted");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configService.unregisterProperties(this.getClass(), false);
        this.stopTest();
        this.log.info("Stopped");
    }

    private void logConfig(String prefix) {
        this.log.info("{} with mapName = {}; readPercentage = {}; totalOperationsPerTransaction = {}; withContention = {}; withRetries = {}; reportIntervalSeconds = {}", new Object[]{prefix, this.mapName, this.readPercentage, this.totalOperationsPerTransaction, this.withContention, this.withRetries, this.reportIntervalSeconds});
    }

    private boolean isParticipant() {
        return this.withContention || this.clusterService.getLocalNode().id().equals((Object)this.clusterService.getNodes().stream().map(ControllerNode::id).min(Comparator.naturalOrder()).get());
    }

    private void initializeMap() {
        TransactionContext context = (TransactionContext)this.storageService.transactionContextBuilder().build();
        context.begin();
        try {
            TransactionalMap map = context.getTransactionalMap(this.mapName, this.serializer);
            for (int i = 0; i < this.totalOperationsPerTransaction; ++i) {
                map.put((Object)(KEY_PREFIX + i), (Object)(KEY_PREFIX + i));
            }
            context.commit().join();
        }
        catch (Exception e) {
            context.abort();
            this.log.warn("An exception occurred during initialization: {}", (Throwable)e);
        }
    }

    private void startTest() {
        this.logConfig("Started");
        this.initializeMap();
        this.runTest(this.iteration.getAndIncrement());
    }

    private void runTest(int iteration) {
        this.testRunner.execute(() -> {
            CommitStatus status = null;
            do {
                TransactionContext context = (TransactionContext)this.storageService.transactionContextBuilder().build();
                context.begin();
                try {
                    TransactionalMap map = context.getTransactionalMap(this.mapName, this.serializer);
                    int reads = (int)((double)this.totalOperationsPerTransaction * this.readPercentage);
                    for (int i = 0; i < reads; ++i) {
                        map.get((Object)(KEY_PREFIX + i));
                    }
                    int writes = (int)((double)this.totalOperationsPerTransaction * (1.0 - this.readPercentage));
                    for (int i = 0; i < writes; ++i) {
                        map.put((Object)(KEY_PREFIX + i), (Object)(KEY_PREFIX + iteration + i));
                    }
                    status = (CommitStatus)context.commit().join();
                    this.attempted.incrementAndGet();
                }
                catch (Exception e) {
                    context.abort();
                    this.log.warn("An exception occurred during a transaction: {}", (Throwable)e);
                }
            } while (this.withRetries && status != CommitStatus.SUCCESS);
            if (status == CommitStatus.SUCCESS) {
                this.succeeded.incrementAndGet();
            }
            this.runTest(this.iteration.getAndIncrement());
        });
    }

    private void reportPerformance() {
        this.log.info("Attempted: {} Succeeded: {} Total iterations: {}", new Object[]{this.attempted.getAndSet(0), this.succeeded.getAndSet(0), this.iteration.get()});
    }

    private void stopTest() {
        this.testRunner.shutdown();
        this.reporter.shutdown();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }
}

