/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng.cli;

import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.virtualbng.VbngConfigurationService;

@Command(scope="onos", name="vbngs", description="Lists all vBNG IP address mapping entries")
public class MappingListCommand
extends AbstractShellCommand {
    private static final String FORMAT_HEADER = "   Private IP - Public IP";
    private static final String FORMAT_MAPPING = "   %s - %s";

    protected void execute() {
        VbngConfigurationService service = (VbngConfigurationService)AbstractShellCommand.get(VbngConfigurationService.class);
        this.printMappingEntries(service.getIpAddressMappings());
    }

    private void printMappingEntries(Map<IpAddress, IpAddress> map) {
        this.print(FORMAT_HEADER, new Object[0]);
        for (Map.Entry<IpAddress, IpAddress> entry : map.entrySet()) {
            this.print(FORMAT_MAPPING, new Object[]{entry.getKey(), entry.getValue()});
        }
        this.print("", new Object[0]);
    }
}

